/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.utils;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.GetJFrogPlatformInstancesExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.ConanClient;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.CreateBuildDataFileCallable;
import org.jfrog.hudson.pipeline.declarative.utils.ReadBuildDataFileCallable;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.SerializationUtils;

public class DeclarativePipelineUtils {
    static final String PIPELINE_CACHE_DIR_NAME = "artifactory-pipeline-cache";

    public static void writeBuildDataFile(FilePath rootWs, String buildNumber, BuildDataFile buildDataFile, Log logger) throws Exception {
        ExtractorUtils.createAndGetTempDir(rootWs).act((FilePath.FileCallable)new CreateBuildDataFileCallable(buildNumber, buildDataFile, logger));
    }

    public static BuildDataFile readBuildDataFile(FilePath rootWs, String buildNumber, String stepName, String stepId) throws IOException, InterruptedException {
        return (BuildDataFile)ExtractorUtils.createAndGetTempDir(rootWs).act((FilePath.FileCallable)new ReadBuildDataFileCallable(buildNumber, stepName, stepId));
    }

    static String getBuildDataFileName(String stepName, String stepId) throws UnsupportedEncodingException {
        return stepName + "_" + Base64.encodeBase64URLSafeString((byte[])stepId.getBytes(StandardCharsets.UTF_8.name()));
    }

    public static ArtifactoryServer getArtifactoryServer(Run<?, ?> build, FilePath rootWs, String id, boolean throwIfMissing) throws IOException, InterruptedException {
        JFrogPlatformInstance instance = DeclarativePipelineUtils.getJFrogPlatformInstance(build, rootWs, id, throwIfMissing);
        return instance != null ? instance.getArtifactory() : null;
    }

    public static DistributionServer getDistributionServer(Run<?, ?> build, FilePath rootWs, String id, boolean throwIfMissing) throws IOException, InterruptedException {
        JFrogPlatformInstance instance = DeclarativePipelineUtils.getJFrogPlatformInstance(build, rootWs, id, throwIfMissing);
        return instance != null ? instance.getDistribution() : null;
    }

    public static JFrogPlatformInstance getJFrogPlatformInstance(Run<?, ?> build, FilePath rootWs, String id, boolean throwIfMissing) throws IOException, InterruptedException {
        String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(rootWs, buildNumber, "jfrogInstance", id);
        if (buildDataFile == null) {
            GetJFrogPlatformInstancesExecutor getJFrogPlatformInstancesExecutor = new GetJFrogPlatformInstancesExecutor(build, id);
            try {
                getJFrogPlatformInstancesExecutor.execute();
            }
            catch (GetJFrogPlatformInstancesExecutor.ServerNotFoundException serverNotFound) {
                if (throwIfMissing) {
                    throw serverNotFound;
                }
                return null;
            }
            return getJFrogPlatformInstancesExecutor.getJFrogPlatformInstance();
        }
        JsonNode jsonNode = buildDataFile.get("jfrogInstance");
        JFrogPlatformInstance instance = (JFrogPlatformInstance)SerializationUtils.createMapper().treeToValue((TreeNode)jsonNode, JFrogPlatformInstance.class);
        DeclarativePipelineUtils.populateArtifactoryServer(instance, jsonNode);
        DeclarativePipelineUtils.populateDistributionServer(instance, jsonNode);
        return instance;
    }

    private static void populateArtifactoryServer(JFrogPlatformInstance instance, JsonNode jsonNode) {
        JsonNode password;
        JsonNode artifactoryNode = jsonNode.get("artifactory");
        if (artifactoryNode == null) {
            return;
        }
        JsonNode credentialsId = artifactoryNode.get("credentialsId");
        if (credentialsId != null && !credentialsId.asText().isEmpty()) {
            instance.getArtifactory().setCredentialsId(credentialsId.asText());
            return;
        }
        JsonNode username = artifactoryNode.get("username");
        if (username != null) {
            instance.getArtifactory().setUsername(username.asText());
        }
        if ((password = artifactoryNode.get("password")) != null) {
            instance.getArtifactory().setPassword(password.asText());
        }
    }

    private static void populateDistributionServer(JFrogPlatformInstance instance, JsonNode jsonNode) {
        JsonNode password;
        JsonNode distributionNode = jsonNode.get("distribution");
        if (distributionNode == null) {
            return;
        }
        JsonNode credentialsId = distributionNode.get("credentialsId");
        if (credentialsId != null && !credentialsId.asText().isEmpty()) {
            instance.getDistribution().setCredentialsId(credentialsId.asText());
            return;
        }
        JsonNode username = distributionNode.get("username");
        if (username != null) {
            instance.getDistribution().setUsername(username.asText());
        }
        if ((password = distributionNode.get("password")) != null) {
            instance.getDistribution().setPassword(password.asText());
        }
    }

    public static String createBuildInfoId(Run<?, ?> build, String customBuildName, String customBuildNumber, String project) {
        String projectId = StringUtils.isNotEmpty((CharSequence)project) ? "_" + project : "";
        return (String)StringUtils.defaultIfEmpty((CharSequence)customBuildName, (CharSequence)BuildUniqueIdentifierHelper.getBuildName(build)) + "_" + (String)StringUtils.defaultIfEmpty((CharSequence)customBuildNumber, (CharSequence)BuildUniqueIdentifierHelper.getBuildNumber(build)) + projectId;
    }

    public static BuildInfo getBuildInfo(FilePath rootWs, Run<?, ?> build, String customBuildName, String customBuildNumber, String project) throws IOException, InterruptedException {
        String buildInfoId;
        String jobBuildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(rootWs, jobBuildNumber, "rtBuildInfo", buildInfoId = DeclarativePipelineUtils.createBuildInfoId(build, customBuildName, customBuildNumber, project));
        if (buildDataFile == null) {
            BuildInfo buildInfo = new BuildInfo(build);
            if (StringUtils.isNotBlank((CharSequence)customBuildName)) {
                buildInfo.setName(customBuildName);
            }
            if (StringUtils.isNotBlank((CharSequence)customBuildNumber)) {
                buildInfo.setNumber(customBuildNumber);
            }
            buildInfo.setProject(project);
            return buildInfo;
        }
        return (BuildInfo)SerializationUtils.createMapper().treeToValue((TreeNode)buildDataFile.get("rtBuildInfo"), BuildInfo.class);
    }

    public static void saveBuildInfo(BuildInfo buildInfo, FilePath rootWs, Run<?, ?> build, Log logger) throws Exception {
        String jobBuildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        String buildInfoId = DeclarativePipelineUtils.createBuildInfoId(build, buildInfo.getName(), buildInfo.getNumber(), buildInfo.getProject());
        BuildDataFile buildDataFile = new BuildDataFile("rtBuildInfo", buildInfoId);
        buildDataFile.putPOJO(buildInfo);
        DeclarativePipelineUtils.writeBuildDataFile(rootWs, jobBuildNumber, buildDataFile, logger);
    }

    static void deleteOldBuildDataDirs(File tmpDir, Log logger) {
        if (!tmpDir.exists()) {
            return;
        }
        File[] buildDataDirs = tmpDir.listFiles(buildDataDir -> {
            long ageInMilliseconds = new Date().getTime() - buildDataDir.lastModified();
            return ageInMilliseconds > TimeUnit.DAYS.toMillis(1L);
        });
        if (buildDataDirs == null) {
            logger.error("Failed while attempting to delete old build data dirs. Could not list files in " + tmpDir);
            return;
        }
        Arrays.stream(buildDataDirs).forEach(buildDataDir -> DeclarativePipelineUtils.deleteBuildDataDir(buildDataDir, logger));
    }

    public static void deleteBuildDataDir(File buildDataDir, Log logger) {
        try {
            FileUtils.deleteDirectory((File)buildDataDir);
            logger.debug(buildDataDir.getAbsolutePath() + " deleted");
        }
        catch (IOException e) {
            logger.error("Failed while attempting to delete old build data dir: " + buildDataDir.toString(), (Throwable)e);
        }
    }

    public static void deleteBuildDataDir(FilePath ws, String buildNumber, Log logger) {
        try {
            FilePath buildDataDir = ExtractorUtils.createAndGetTempDir(ws).child(PIPELINE_CACHE_DIR_NAME).child(buildNumber);
            buildDataDir.deleteRecursive();
            logger.debug(buildDataDir.getRemote() + " deleted");
        }
        catch (IOException | InterruptedException e) {
            logger.error("Failed while attempting to delete build data dir for build number " + buildNumber, (Throwable)e);
        }
    }

    public static ConanClient buildConanClient(String clientId, String buildNumber, String stepName, Launcher launcher, FilePath ws, FilePath rootWs, EnvVars env) throws Exception {
        ConanClient conanClient = new ConanClient();
        conanClient.setUnixAgent(launcher.isUnix());
        BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(rootWs, buildNumber, stepName, clientId);
        if (buildDataFile == null) {
            throw new IOException("Conan client " + clientId + " doesn't exist.");
        }
        String userHome = buildDataFile.get("userHome") == null ? "" : buildDataFile.get("userHome").asText();
        FilePath conanHomeDirectory = Utils.getConanHomeDirectory(userHome, env, launcher, ws);
        conanClient.setUserPath(conanHomeDirectory.getRemote());
        return conanClient;
    }
}

