/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.dsl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.ConanClient;
import org.jfrog.hudson.pipeline.common.types.Docker;
import org.jfrog.hudson.pipeline.common.types.MavenDescriptor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.GoBuild;
import org.jfrog.hudson.pipeline.common.types.builds.GradleBuild;
import org.jfrog.hudson.pipeline.common.types.builds.MavenBuild;
import org.jfrog.hudson.pipeline.common.types.builds.NpmBuild;
import org.jfrog.hudson.pipeline.common.types.builds.NugetBuild;
import org.jfrog.hudson.pipeline.common.types.builds.PipBuild;

public class ArtifactoryPipelineGlobal
implements Serializable {
    private CpsScript cpsScript;

    public ArtifactoryPipelineGlobal(CpsScript script) {
        this.cpsScript = script;
    }

    @Whitelisted
    public ArtifactoryServer server(String serverName) {
        LinkedHashMap<String, String> stepVariables = new LinkedHashMap<String, String>();
        stepVariables.put("artifactoryServerID", serverName);
        ArtifactoryServer server = (ArtifactoryServer)this.cpsScript.invokeMethod("getArtifactoryServer", stepVariables);
        server.setCpsScript(this.cpsScript);
        return server;
    }

    @Whitelisted
    public Docker docker(ArtifactoryServer server) {
        return this.docker(server, "");
    }

    @Whitelisted
    public Docker docker(ArtifactoryServer server, String host) {
        LinkedHashMap<String, Object> dockerArguments = new LinkedHashMap<String, Object>();
        dockerArguments.put("server", server);
        if (host != null && !host.isEmpty()) {
            dockerArguments.put("host", host);
        }
        return this.docker(dockerArguments);
    }

    @Whitelisted
    public Docker docker(Map<String, Object> dockerArguments) {
        List<String> keysAsList = Arrays.asList("server", "host", "javaArgs");
        if (!keysAsList.containsAll(dockerArguments.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList);
        }
        Object server = dockerArguments.remove("server");
        ObjectMapper mapper = new ObjectMapper();
        Docker docker = (Docker)mapper.convertValue(dockerArguments, Docker.class);
        docker.setCpsScript(this.cpsScript);
        if (server != null) {
            docker.setServer((ArtifactoryServer)server);
        }
        return docker;
    }

    @Whitelisted
    public ArtifactoryServer newServer(String url, String username, String password) {
        LinkedHashMap<String, String> stepVariables = new LinkedHashMap<String, String>();
        stepVariables.put("url", url);
        stepVariables.put("username", username);
        stepVariables.put("password", password);
        ArtifactoryServer server = (ArtifactoryServer)this.cpsScript.invokeMethod("newArtifactoryServer", stepVariables);
        server.setCpsScript(this.cpsScript);
        return server;
    }

    @Whitelisted
    public ArtifactoryServer newServer(Map<String, Object> serverArguments) {
        List<String> keysAsList = Arrays.asList("url", "username", "password", "credentialsId");
        if (!keysAsList.containsAll(serverArguments.keySet())) {
            throw new IllegalArgumentException("The newServer method accepts the following arguments only: " + keysAsList);
        }
        ArtifactoryServer server = (ArtifactoryServer)this.cpsScript.invokeMethod("newArtifactoryServer", serverArguments);
        server.setCpsScript(this.cpsScript);
        return server;
    }

    @Whitelisted
    public BuildInfo newBuildInfo() {
        BuildInfo buildInfo = (BuildInfo)this.cpsScript.invokeMethod("newBuildInfo", new LinkedHashMap());
        buildInfo.setCpsScript(this.cpsScript);
        return buildInfo;
    }

    @Whitelisted
    public BuildInfo newBuildInfo(String buildName, String buildNumber) {
        return this.newBuildInfo(buildName, buildNumber, null);
    }

    @Whitelisted
    public BuildInfo newBuildInfo(String buildName, String buildNumber, String project) {
        BuildInfo buildInfo = this.newBuildInfo();
        buildInfo.setName(buildName);
        buildInfo.setNumber(buildNumber);
        buildInfo.setProject(project);
        return buildInfo;
    }

    @Whitelisted
    public MavenBuild newMavenBuild() {
        MavenBuild mavenBuild = (MavenBuild)this.cpsScript.invokeMethod("newMavenBuild", new LinkedHashMap());
        mavenBuild.setCpsScript(this.cpsScript);
        return mavenBuild;
    }

    @Whitelisted
    public GradleBuild newGradleBuild() {
        GradleBuild gradleBuild = (GradleBuild)this.cpsScript.invokeMethod("newGradleBuild", new LinkedHashMap());
        gradleBuild.setCpsScript(this.cpsScript);
        return gradleBuild;
    }

    @Whitelisted
    public NpmBuild newNpmBuild() {
        NpmBuild npmBuild = (NpmBuild)this.cpsScript.invokeMethod("newNpmBuild", new LinkedHashMap());
        npmBuild.setCpsScript(this.cpsScript);
        return npmBuild;
    }

    @Whitelisted
    public GoBuild newGoBuild() {
        GoBuild goBuild = (GoBuild)this.cpsScript.invokeMethod("newGoBuild", new LinkedHashMap());
        goBuild.setCpsScript(this.cpsScript);
        return goBuild;
    }

    @Whitelisted
    public PipBuild newPipBuild() {
        PipBuild pipBuild = (PipBuild)this.cpsScript.invokeMethod("newPipBuild", new LinkedHashMap());
        pipBuild.setCpsScript(this.cpsScript);
        return pipBuild;
    }

    @Whitelisted
    public NugetBuild newNugetBuild() {
        NugetBuild nugetBuild = (NugetBuild)this.cpsScript.invokeMethod("newNugetBuild", new LinkedHashMap());
        nugetBuild.setCpsScript(this.cpsScript);
        return nugetBuild;
    }

    @Whitelisted
    public NugetBuild newDotnetBuild() {
        NugetBuild dotnetCliBuild = (NugetBuild)this.cpsScript.invokeMethod("newNugetBuild", new LinkedHashMap());
        dotnetCliBuild.setCpsScript(this.cpsScript);
        dotnetCliBuild.setUseDotnetCli(true);
        return dotnetCliBuild;
    }

    @Whitelisted
    public ConanClient newConanClient(Map<String, Object> clientArgs) {
        ConanClient client = new ConanClient();
        String userPath = (String)clientArgs.get("userHome");
        if (StringUtils.isBlank((CharSequence)userPath)) {
            throw new IllegalArgumentException("The newConanClient method expects the 'userHome' argument or no arguments.");
        }
        client.setUserPath(userPath);
        client.setCpsScript(this.cpsScript);
        LinkedHashMap<String, ConanClient> args = new LinkedHashMap<String, ConanClient>();
        args.put("client", client);
        this.cpsScript.invokeMethod("initConanClient", args);
        return client;
    }

    @Whitelisted
    public ConanClient newConanClient() {
        ConanClient client = new ConanClient();
        client.setCpsScript(this.cpsScript);
        LinkedHashMap<String, ConanClient> args = new LinkedHashMap<String, ConanClient>();
        args.put("client", client);
        this.cpsScript.invokeMethod("initConanClient", args);
        return client;
    }

    @Whitelisted
    public MavenDescriptor mavenDescriptor() {
        MavenDescriptor descriptorHandler = new MavenDescriptor();
        descriptorHandler.setCpsScript(this.cpsScript);
        return descriptorHandler;
    }

    @Whitelisted
    public void addInteractivePromotion(Map<String, Object> promotionArguments) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        List<String> mandatoryParams = Arrays.asList("server", "promotionConfig");
        List<String> allowedParams = Arrays.asList("server", "promotionConfig", "displayName");
        if (!promotionArguments.keySet().containsAll(mandatoryParams)) {
            throw new IllegalArgumentException(mandatoryParams.toString() + " are mandatory arguments");
        }
        if (!allowedParams.containsAll(promotionArguments.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + allowedParams.toString());
        }
        stepVariables.put("promotionConfig", Utils.createPromotionConfig((Map)promotionArguments.get("promotionConfig"), false));
        stepVariables.put("server", promotionArguments.get("server"));
        stepVariables.put("displayName", promotionArguments.get("displayName"));
        this.cpsScript.invokeMethod("addInteractivePromotion", stepVariables);
    }
}

