/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.GradleExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.GradleBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArtifactoryGradleBuild
extends AbstractStepImpl {
    static final String STEP_NAME = "ArtifactoryGradleBuild";
    private GradleBuild gradleBuild;
    private String tasks;
    private String buildFile;
    private String rootDir;
    private String switches;
    private BuildInfo buildInfo;

    @DataBoundConstructor
    public ArtifactoryGradleBuild(GradleBuild gradleBuild, String rootDir, String buildFile, String tasks, String switches, BuildInfo buildInfo) {
        this.gradleBuild = gradleBuild;
        this.tasks = tasks;
        this.rootDir = rootDir;
        this.buildFile = buildFile;
        this.switches = switches;
        this.buildInfo = buildInfo;
    }

    private GradleBuild getGradleBuild() {
        return this.gradleBuild;
    }

    private String getSwitches() {
        return this.switches;
    }

    private String getTasks() {
        return this.tasks;
    }

    private String getBuildFile() {
        return this.buildFile;
    }

    private BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    private String getRootDir() {
        return this.rootDir;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return ArtifactoryGradleBuild.STEP_NAME;
        }

        public String getDisplayName() {
            return "run Artifactory gradle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        protected static final long serialVersionUID = 1L;
        private transient ArtifactoryGradleBuild step;

        @Inject
        public Execution(ArtifactoryGradleBuild step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            GradleExecutor gradleExecutor = new GradleExecutor((Run<?, ?>)this.build, this.step.getGradleBuild(), this.step.getTasks(), this.step.getBuildFile(), this.step.getRootDir(), this.step.getSwitches(), this.step.getBuildInfo(), this.env, this.ws, this.listener, this.launcher);
            gradleExecutor.execute();
            return gradleExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            Deployer deployer = this.step.gradleBuild.getDeployer();
            if (deployer != null) {
                return deployer.getArtifactoryServer();
            }
            Resolver resolver = this.step.gradleBuild.getResolver();
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return ArtifactoryGradleBuild.STEP_NAME;
        }
    }
}

