/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.MavenExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.MavenBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.MavenResolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArtifactoryMavenBuild
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryMavenBuild";
    private MavenBuild mavenBuild;
    private String goals;
    private String pom;
    private BuildInfo buildInfo;

    @DataBoundConstructor
    public ArtifactoryMavenBuild(MavenBuild mavenBuild, String pom, String goals, BuildInfo buildInfo) {
        this.mavenBuild = mavenBuild;
        this.goals = goals == null ? "" : goals;
        this.pom = pom == null ? "" : pom;
        this.buildInfo = buildInfo;
    }

    private MavenBuild getMavenBuild() {
        return this.mavenBuild;
    }

    private String getGoals() {
        return this.goals;
    }

    private String getPom() {
        return this.pom;
    }

    private BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return ArtifactoryMavenBuild.STEP_NAME;
        }

        public String getDisplayName() {
            return "run Artifactory maven";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        protected static final long serialVersionUID = 1L;
        private transient ArtifactoryMavenBuild step;

        @Inject
        public Execution(ArtifactoryMavenBuild step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            MavenBuild mavenBuild = this.step.getMavenBuild();
            MavenExecutor mavenExecutor = new MavenExecutor(this.listener, this.launcher, (Run)this.build, this.ws, this.env, mavenBuild, this.step.getPom(), this.step.getGoals(), this.step.getBuildInfo());
            mavenExecutor.execute();
            return mavenExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            Deployer deployer = this.step.mavenBuild.getDeployer();
            if (deployer != null) {
                return deployer.getArtifactoryServer();
            }
            MavenResolver resolver = this.step.mavenBuild.getResolver();
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return ArtifactoryMavenBuild.STEP_NAME;
        }
    }
}

