/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.BuildAppendExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildAppendStep
extends AbstractStepImpl {
    static final String STEP_NAME = "buildAppend";
    private final String buildNumber;
    private final String buildName;
    private final org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private final BuildInfo buildInfo;

    @DataBoundConstructor
    public BuildAppendStep(BuildInfo buildInfo, String buildName, String buildNumber, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) {
        this.buildNumber = buildNumber;
        this.buildName = buildName;
        this.buildInfo = buildInfo;
        this.server = server;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return BuildAppendStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Build append";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient BuildAppendStep step;

        @Inject
        public Execution(BuildAppendStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            new BuildAppendExecutor(this.step.server, this.step.buildInfo, this.step.buildName, this.step.buildNumber, (Run<?, ?>)this.build, this.listener).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return BuildAppendStep.STEP_NAME;
        }
    }
}

