/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.BuildTriggerExecutor;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildTriggerStep
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryBuildTrigger";
    private final org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private final String paths;
    private final String spec;

    @DataBoundConstructor
    public BuildTriggerStep(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String paths, String spec) {
        this.server = server;
        this.paths = paths;
        this.spec = spec;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return BuildTriggerStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Trigger Artifactory build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient BuildTriggerStep step;

        @Inject
        public Execution(BuildTriggerStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            new BuildTriggerExecutor((Run<?, ?>)this.build, this.listener, this.step.server, this.step.paths, this.step.spec).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.server);
        }

        @Override
        public String getUsageReportFeatureName() {
            return BuildTriggerStep.STEP_NAME;
        }
    }
}

