/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.CollectEnvExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Env;
import org.kohsuke.stapler.DataBoundConstructor;

public class CollectEnvStep
extends AbstractStepImpl {
    static final String STEP_NAME = "collectEnv";
    private Env env;

    @DataBoundConstructor
    public CollectEnvStep(Env env) {
        this.env = env;
    }

    public Env getEnv() {
        return this.env;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return CollectEnvStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Collect environment variables and system properties";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private transient CollectEnvStep step;

        @Inject
        public Execution(CollectEnvStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            CollectEnvExecutor collectEnvExecutor = new CollectEnvExecutor((Run<?, ?>)this.build, this.listener, this.ws, this.step.getEnv(), this.env);
            collectEnvExecutor.execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return null;
        }
    }
}

