/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.BuildInfoProcessRunner;
import org.jfrog.hudson.pipeline.common.executors.CreateDockerBuildExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateDockerBuildStep
extends AbstractStepImpl {
    static final String STEP_NAME = "createDockerBuildStep";
    private final org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private final String kanikoImageFile;
    private final String jibImageFiles;
    private final BuildInfo buildInfo;
    private final String sourceRepo;
    private final String javaArgs;

    @DataBoundConstructor
    public CreateDockerBuildStep(String kanikoImageFile, String jibImageFiles, String sourceRepo, BuildInfo buildInfo, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String javaArgs) {
        this.kanikoImageFile = kanikoImageFile;
        this.jibImageFiles = jibImageFiles;
        this.sourceRepo = sourceRepo;
        this.buildInfo = buildInfo;
        this.javaArgs = javaArgs;
        this.server = server;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getSourceRepo() {
        return this.sourceRepo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return CreateDockerBuildStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Artifactory create Docker build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        protected static final long serialVersionUID = 1L;
        private final transient CreateDockerBuildStep step;

        @Inject
        public Execution(CreateDockerBuildStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            BuildInfo buildInfo = Utils.prepareBuildinfo((Run)this.build, this.step.getBuildInfo());
            CreateDockerBuildExecutor dockerExecutor = new CreateDockerBuildExecutor(this.step.server, buildInfo, (Run<?, ?>)this.build, this.step.kanikoImageFile, this.step.jibImageFiles, this.step.sourceRepo, this.step.javaArgs, this.launcher, this.listener, this.ws, this.env);
            dockerExecutor.execute();
            return ((BuildInfoProcessRunner)dockerExecutor).getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return CreateDockerBuildStep.STEP_NAME;
        }
    }
}

