/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateJFrogPlatformInstanceStep
extends AbstractStepImpl {
    private final String distributionUrl;
    private final String artifactoryUrl;
    private final String credentialsId;
    private final String username;
    private final String password;
    private final String url;

    @DataBoundConstructor
    public CreateJFrogPlatformInstanceStep(String url, String artifactoryUrl, String distributionUrl, String username, String password, String credentialsId) {
        this.url = url;
        this.artifactoryUrl = artifactoryUrl;
        this.distributionUrl = distributionUrl;
        this.username = username;
        this.password = password;
        this.credentialsId = credentialsId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "newJFrogPlatformInstance";
        }

        @Nonnull
        public String getDisplayName() {
            return "Returns new JFrog platform instance";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends SynchronousStepExecution<JFrogPlatformInstance> {
        private static final long serialVersionUID = 1L;
        private transient CreateJFrogPlatformInstanceStep step;

        @Inject
        public Execution(CreateJFrogPlatformInstanceStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected JFrogPlatformInstance run() throws Exception {
            DistributionServer distributionServer;
            ArtifactoryServer artifactoryServer;
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.step.url, this.step.artifactoryUrl, this.step.distributionUrl})) {
                throw new IllegalArgumentException("At least one of the following is mandatory: 'url', 'artifactoryUrl', 'distributionUrl'");
            }
            String urlWithoutSlash = StringUtils.removeEnd((String)this.step.url, (String)"/");
            String artifactoryUrl = (String)StringUtils.defaultIfBlank((CharSequence)this.step.artifactoryUrl, (CharSequence)(urlWithoutSlash + "/artifactory"));
            String distributionUrl = (String)StringUtils.defaultIfBlank((CharSequence)this.step.distributionUrl, (CharSequence)(urlWithoutSlash + "/distribution"));
            if (!StringUtils.isEmpty((CharSequence)this.step.credentialsId)) {
                artifactoryServer = new ArtifactoryServer(artifactoryUrl, this.step.credentialsId);
                distributionServer = new DistributionServer(distributionUrl, this.step.credentialsId);
            } else {
                artifactoryServer = new ArtifactoryServer(artifactoryUrl, this.step.username, this.step.password);
                distributionServer = new DistributionServer(distributionUrl, this.step.username, this.step.password);
            }
            artifactoryServer.setPlatformUrl(urlWithoutSlash);
            return new JFrogPlatformInstance(artifactoryServer, distributionServer, this.step.url, "");
        }
    }
}

