/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeployStep
extends AbstractStepImpl {
    static final String STEP_NAME = "deployArtifacts";
    private Deployer deployer;
    private BuildInfo buildInfo;

    @DataBoundConstructor
    public DeployStep(Deployer deployer, BuildInfo buildInfo) {
        this.deployer = deployer;
        this.buildInfo = buildInfo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return DeployStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Deploy artifacts";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Boolean> {
        protected static final long serialVersionUID = 1L;
        private transient DeployStep step;

        @Inject
        public Execution(DeployStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Boolean runStep() throws Exception {
            this.step.deployer.deployArtifacts(this.step.buildInfo, this.listener, this.ws, (Run)this.build);
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return this.step.deployer.getArtifactoryServer();
        }

        @Override
        public String getUsageReportFeatureName() {
            return "deployArtifacts_" + this.step.deployer.getClass().getSimpleName();
        }
    }
}

