/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.DistributionExecutor;
import org.jfrog.hudson.pipeline.common.types.DistributionConfig;
import org.kohsuke.stapler.DataBoundConstructor;

public class DistributeBuildStep
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryDistributeBuild";
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private DistributionConfig distributionConfig;

    @DataBoundConstructor
    public DistributeBuildStep(DistributionConfig distributionConfig, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) {
        this.distributionConfig = distributionConfig;
        this.server = server;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public DistributionConfig getDistributionConfig() {
        return this.distributionConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return DistributeBuildStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Distribute build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Boolean> {
        protected static final long serialVersionUID = 1L;
        private transient DistributeBuildStep step;

        @Inject
        public Execution(DistributeBuildStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Boolean runStep() throws Exception {
            DistributionConfig distributionConfig = this.step.getDistributionConfig();
            if (StringUtils.isEmpty((CharSequence)distributionConfig.getBuildName())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Distribution build name is mandatory"));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)distributionConfig.getBuildNumber())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Distribution build number is mandatory"));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)distributionConfig.getTargetRepo())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Distribution target repository is mandatory"));
                return false;
            }
            new DistributionExecutor(Utils.prepareArtifactoryServer(null, this.step.getServer()), (Run)this.build, this.listener, this.getContext(), distributionConfig).execute();
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return DistributeBuildStep.STEP_NAME;
        }
    }
}

