/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.cli.MissingArgumentException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.DockerPushExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerPushStep
extends AbstractStepImpl {
    static final String STEP_NAME = "dockerPushStep";
    private final String image;
    private final org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private String host;
    private BuildInfo buildInfo;
    private String targetRepo;
    private String javaArgs;
    private ArrayListMultimap<String, String> properties;

    @DataBoundConstructor
    public DockerPushStep(String image, String host, String targetRepo, BuildInfo buildInfo, ArrayListMultimap<String, String> properties, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String javaArgs) {
        this.image = image;
        this.host = host;
        this.targetRepo = targetRepo;
        this.buildInfo = buildInfo;
        this.properties = properties;
        this.server = server;
        this.javaArgs = javaArgs;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public String getImage() {
        return this.image;
    }

    public ArrayListMultimap<String, String> getProperties() {
        return this.properties;
    }

    public String getHost() {
        return this.host;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getTargetRepo() {
        return this.targetRepo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return DockerPushStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Artifactory docker push";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        protected static final long serialVersionUID = 1L;
        private transient DockerPushStep step;

        @Inject
        public Execution(DockerPushStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            if (this.step.getImage() == null) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Missing 'image' parameter"));
                return null;
            }
            if (this.step.getTargetRepo() == null) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Missing 'targetRepo' parameter"));
                return null;
            }
            BuildInfo buildInfo = Utils.prepareBuildinfo((Run)this.build, this.step.getBuildInfo());
            DockerPushExecutor dockerExecutor = new DockerPushExecutor(this.step.getServer(), buildInfo, (Run)this.build, this.step.image, this.step.targetRepo, this.step.host, this.step.javaArgs, this.launcher, (ArrayListMultimap<String, String>)this.step.properties, this.listener, this.ws, this.env);
            dockerExecutor.execute();
            return dockerExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return DockerPushStep.STEP_NAME;
        }
    }
}

