/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.GetJFrogPlatformInstancesExecutor;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetArtifactoryServerStep
extends AbstractStepImpl {
    static final String STEP_NAME = "getArtifactoryServer";
    private final String artifactoryServerID;
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer artifactoryServer;

    @DataBoundConstructor
    public GetArtifactoryServerStep(String artifactoryServerID) {
        this.artifactoryServerID = artifactoryServerID;
    }

    private String getArtifactoryServerID() {
        return this.artifactoryServerID;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return GetArtifactoryServerStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Get Artifactory server from Jenkins config";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<org.jfrog.hudson.pipeline.common.types.ArtifactoryServer> {
        protected static final long serialVersionUID = 1L;
        private final transient GetArtifactoryServerStep step;

        @Inject
        public Execution(GetArtifactoryServerStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected org.jfrog.hudson.pipeline.common.types.ArtifactoryServer runStep() throws Exception {
            String artifactoryServerID = this.step.getArtifactoryServerID();
            GetJFrogPlatformInstancesExecutor getJFrogPlatformInstancesExecutor = new GetJFrogPlatformInstancesExecutor((Run<?, ?>)this.build, artifactoryServerID);
            getJFrogPlatformInstancesExecutor.execute();
            this.step.artifactoryServer = getJFrogPlatformInstancesExecutor.getJFrogPlatformInstance().getArtifactory();
            return this.step.artifactoryServer;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.artifactoryServer);
        }

        @Override
        public String getUsageReportFeatureName() {
            return GetArtifactoryServerStep.STEP_NAME;
        }
    }
}

