/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.NpmInstallCiExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.NpmBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.Resolver;

public abstract class NpmInstallCiStepBase
extends AbstractStepImpl {
    private BuildInfo buildInfo;
    private String javaArgs;
    private String path;
    private String args;
    private String module;
    private boolean isCiCommand;
    private NpmBuild npmBuild;

    protected NpmInstallCiStepBase(BuildInfo buildInfo, NpmBuild npmBuild, String javaArgs, String path, String args, String module, boolean isCiCommand) {
        this.buildInfo = buildInfo;
        this.npmBuild = npmBuild;
        this.javaArgs = javaArgs;
        this.path = path;
        this.args = args;
        this.module = module;
        this.isCiCommand = isCiCommand;
    }

    public abstract String getUsageReportFeatureName();

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        protected static final long serialVersionUID = 1L;
        private transient NpmInstallCiStepBase step;

        @Inject
        public Execution(NpmInstallCiStepBase step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            Utils.addNpmToPath(this.ws, this.listener, this.env, this.launcher, this.step.npmBuild.getTool());
            NpmInstallCiExecutor npmInstallCiExecutor = new NpmInstallCiExecutor(this.step.buildInfo, this.launcher, this.step.npmBuild, this.step.javaArgs, this.step.args, this.ws, this.step.path, this.step.module, this.env, this.listener, (Run)this.build, this.step.isCiCommand);
            npmInstallCiExecutor.execute();
            return npmInstallCiExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            Resolver resolver = this.step.npmBuild.getResolver();
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return this.step.getUsageReportFeatureName();
        }
    }
}

