/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.PipInstallExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.PipBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class PipInstallStep
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryPipRun";
    private BuildInfo buildInfo;
    private PipBuild pipBuild;
    private String javaArgs;
    private String args;
    private String module;
    private String envActivation;

    @DataBoundConstructor
    public PipInstallStep(BuildInfo buildInfo, PipBuild pipBuild, String javaArgs, String args, String envActivation, String module) {
        this.buildInfo = buildInfo;
        this.pipBuild = pipBuild;
        this.javaArgs = javaArgs;
        this.args = args;
        this.envActivation = envActivation;
        this.module = module;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return PipInstallStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Run Artifactory pip install";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        protected static final long serialVersionUID = 1L;
        private transient PipInstallStep step;

        @Inject
        public Execution(PipInstallStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            PipInstallExecutor pipInstallExecutor = new PipInstallExecutor(this.step.buildInfo, this.launcher, this.step.pipBuild, this.step.javaArgs, this.step.args, this.ws, this.step.envActivation, this.step.module, this.env, this.listener, (Run)this.build);
            pipInstallExecutor.execute();
            return pipInstallExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            Resolver resolver = this.step.pipBuild.getResolver();
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return PipInstallStep.STEP_NAME;
        }
    }
}

