/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.PromotionExecutor;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.kohsuke.stapler.DataBoundConstructor;

public class PromoteBuildStep
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryPromoteBuild";
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private PromotionConfig promotionConfig;

    @DataBoundConstructor
    public PromoteBuildStep(PromotionConfig promotionConfig, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) {
        this.promotionConfig = promotionConfig;
        this.server = server;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public PromotionConfig getPromotionConfig() {
        return this.promotionConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return PromoteBuildStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Promote build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Boolean> {
        protected static final long serialVersionUID = 1L;
        private transient PromoteBuildStep step;

        @Inject
        public Execution(PromoteBuildStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Boolean runStep() throws Exception {
            PromotionConfig promotionConfig = this.step.getPromotionConfig();
            if (StringUtils.isEmpty((CharSequence)promotionConfig.getBuildName())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Promotion build name is mandatory"));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)promotionConfig.getBuildNumber())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Promotion build number is mandatory"));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)promotionConfig.getTargetRepo())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Promotion target repository is mandatory"));
                return false;
            }
            new PromotionExecutor(Utils.prepareArtifactoryServer(null, this.step.getServer()), (Run<?, ?>)this.build, this.listener, this.getContext(), promotionConfig).execute();
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return PromoteBuildStep.STEP_NAME;
        }
    }
}

