/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.GenericUploadExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.kohsuke.stapler.DataBoundConstructor;

public class UploadStep
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryUpload";
    private BuildInfo buildInfo;
    private String spec;
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private String module;
    private boolean failNoOp;

    @DataBoundConstructor
    public UploadStep(String spec, BuildInfo buildInfo, boolean failNoOp, String module, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) {
        this.spec = spec;
        this.buildInfo = buildInfo;
        this.failNoOp = failNoOp;
        this.module = module;
        this.server = server;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public boolean getFailNoOp() {
        return this.failNoOp;
    }

    public String getModule() {
        return this.module;
    }

    public String getSpec() {
        return this.spec;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return UploadStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Upload artifacts";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        protected static final long serialVersionUID = 1L;
        private transient UploadStep step;

        @Inject
        public Execution(UploadStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            GenericUploadExecutor genericUploadExecutor = new GenericUploadExecutor(Utils.prepareArtifactoryServer(null, this.step.getServer()), this.listener, (Run)this.build, this.ws, this.step.getBuildInfo(), this.getContext(), Util.replaceMacro((String)this.step.getSpec(), (Map)this.env), this.step.getFailNoOp(), this.step.module);
            genericUploadExecutor.execute();
            BuildInfo buildInfo = genericUploadExecutor.getBuildInfo();
            buildInfo.captureVariables(this.env, (Run)this.build, this.listener);
            return buildInfo;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return UploadStep.STEP_NAME;
        }
    }
}

