/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.XrayExecutor;
import org.jfrog.hudson.pipeline.common.types.XrayScanConfig;
import org.jfrog.hudson.pipeline.common.types.XrayScanResult;
import org.kohsuke.stapler.DataBoundConstructor;

public class XrayScanBuildStep
extends AbstractStepImpl {
    static final String STEP_NAME = "xrayScanBuild";
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private XrayScanConfig xrayScanConfig;

    @DataBoundConstructor
    public XrayScanBuildStep(XrayScanConfig xrayScanConfig, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) {
        this.xrayScanConfig = xrayScanConfig;
        this.server = server;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public XrayScanConfig getXrayScanConfig() {
        return this.xrayScanConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return XrayScanBuildStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Xray build scanning";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<XrayScanResult> {
        protected static final long serialVersionUID = 1L;
        private transient XrayScanBuildStep step;

        @Inject
        public Execution(XrayScanBuildStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected XrayScanResult runStep() throws Exception {
            XrayScanConfig xrayScanConfig = this.step.getXrayScanConfig();
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = this.step.getServer();
            XrayExecutor xrayExecutor = new XrayExecutor(xrayScanConfig, this.listener, server, (Run<?, ?>)this.build);
            xrayExecutor.execute();
            return xrayExecutor.getXrayScanResult();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return XrayScanBuildStep.STEP_NAME;
        }
    }
}

