/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps.conan;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.ConanExecutor;
import org.jfrog.hudson.util.CredentialManager;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddUserStep
extends AbstractStepImpl {
    static final String STEP_NAME = "conanAddUser";
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private String serverName;
    private String conanHome;

    @DataBoundConstructor
    public AddUserStep(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String serverName, String conanHome) {
        this.server = server;
        this.serverName = serverName;
        this.conanHome = conanHome;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getConanHome() {
        return this.conanHome;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return AddUserStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Add new user to Conan config";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Boolean> {
        protected static final long serialVersionUID = 1L;
        private transient AddUserStep step;

        @Inject
        public Execution(AddUserStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Boolean runStep() throws Exception {
            ArtifactoryServer artifactoryServer = Utils.prepareArtifactoryServer(null, this.step.getServer());
            ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(artifactoryServer);
            CredentialsConfig deployerConfig = CredentialManager.getPreferredDeployer(configurator, artifactoryServer);
            String username = deployerConfig.provideCredentials((Item)this.build.getParent()).getUsername();
            String password = deployerConfig.provideCredentials((Item)this.build.getParent()).getPassword();
            String serverName = this.step.getServerName();
            ConanExecutor executor = new ConanExecutor(this.step.getConanHome(), this.ws, this.launcher, this.listener, this.env, (Run)this.build);
            executor.execUserAdd(username, password, serverName);
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return AddUserStep.STEP_NAME;
        }
    }
}

