/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps.conan;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.ConanExecutor;
import org.jfrog.hudson.pipeline.common.types.ConanClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class InitConanClientStep
extends AbstractStepImpl {
    static final String STEP_NAME = "initConanClient";
    private ConanClient client;

    @DataBoundConstructor
    public InitConanClientStep(ConanClient client) {
        this.client = client;
    }

    public ConanClient getClient() {
        return this.client;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return InitConanClientStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Create Conan Client";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Boolean> {
        protected static final long serialVersionUID = 1L;
        private transient InitConanClientStep step;

        @Inject
        public Execution(InitConanClientStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Boolean runStep() throws Exception {
            ConanClient conanClient = this.getConanClient();
            ConanExecutor conanExecutor = new ConanExecutor(conanClient.getUserPath(), this.ws, this.launcher, this.listener, this.env, (Run)this.build);
            conanExecutor.execClientInit();
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return null;
        }

        private ConanClient getConanClient() throws Exception {
            ConanClient conanClient = this.step.getClient();
            conanClient.setUnixAgent(this.launcher.isUnix());
            FilePath conanHomeDirectory = Utils.getConanHomeDirectory(conanClient.getUserPath(), this.env, this.launcher, this.ws);
            conanClient.setUserPath(conanHomeDirectory.getRemote());
            return conanClient;
        }
    }
}

