/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps.distribution;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.ReleaseBundleUpdateExecutor;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.scripted.steps.distribution.CreateUpdateReleaseBundleStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class UpdateReleaseBundleStep
extends CreateUpdateReleaseBundleStep {
    static final String STEP_NAME = "updateReleaseBundle";

    @DataBoundConstructor
    public UpdateReleaseBundleStep(DistributionServer server, String name, String version, String spec, String storingRepo, boolean signImmediately, boolean dryRun, String gpgPassphrase, String releaseNotesPath, String releaseNotesSyntax, String description) {
        super(server, name, version, spec, storingRepo, signImmediately, dryRun, gpgPassphrase, releaseNotesPath, releaseNotesSyntax, description);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return UpdateReleaseBundleStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Update a release bundle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient UpdateReleaseBundleStep step;

        @Inject
        public Execution(UpdateReleaseBundleStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            new ReleaseBundleUpdateExecutor(this.step.getServer(), this.step.name, this.step.version, this.step.getSpec(), this.step.storingRepo, this.step.signImmediately, this.step.dryRun, this.step.gpgPassphrase, this.step.releaseNotesPath, this.step.releaseNotesSyntax, this.step.description, this.listener, (Run<?, ?>)this.build, this.ws, this.env).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return UpdateReleaseBundleStep.STEP_NAME;
        }
    }
}

