/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.types;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.build.extractor.ci.BaseBuildFileBean;

public class File
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String localPath;
    private String remotePath;
    private String md5;
    private String sha1;
    private String sha256;

    public File() {
    }

    public File(BaseBuildFileBean baseBuildFileBean) {
        this.localPath = baseBuildFileBean.getLocalPath();
        this.remotePath = baseBuildFileBean.getRemotePath();
        this.md5 = baseBuildFileBean.getMd5();
        this.sha1 = baseBuildFileBean.getSha1();
        this.sha256 = baseBuildFileBean.getSha256();
    }

    @Whitelisted
    public String getLocalPath() {
        return this.localPath;
    }

    @Whitelisted
    public String getRemotePath() {
        return this.remotePath;
    }

    @Whitelisted
    public String getMd5() {
        return this.md5;
    }

    @Whitelisted
    public String getSha1() {
        return this.sha1;
    }

    @Whitelisted
    public String getSha256() {
        return this.sha256;
    }

    public int hashCode() {
        return Objects.hash(this.localPath, this.remotePath);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this == other) {
            return true;
        }
        File otherFile = (File)other;
        return StringUtils.equals((CharSequence)this.localPath, (CharSequence)otherFile.getLocalPath()) && StringUtils.equals((CharSequence)this.remotePath, (CharSequence)otherFile.getRemotePath());
    }

    public String toString() {
        return "{localPath='" + this.localPath + "', remotePath='" + this.remotePath + "', md5=" + this.md5 + ", sha256=" + this.sha256 + ", sha1=" + this.sha1 + "}";
    }
}

