/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release;

import hudson.model.TaskListener;
import java.io.IOException;
import org.jfrog.build.api.builder.DistributionBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class DistributionUtils {
    public static boolean distributeAndCheckResponse(DistributionBuilder distributionBuilder, ArtifactoryManager artifactoryManager, TaskListener listener, String buildName, String buildNumber, boolean dryRun) {
        listener.getLogger().println("Performing dry run distribution (no changes are made during dry run) ...");
        if (!DistributionUtils.distribute(distributionBuilder, artifactoryManager, listener, buildName, buildNumber, true)) {
            return false;
        }
        listener.getLogger().println("Dry run finished successfully");
        if (!dryRun) {
            listener.getLogger().println("Performing distribution ...");
            if (!DistributionUtils.distribute(distributionBuilder, artifactoryManager, listener, buildName, buildNumber, false)) {
                return false;
            }
            listener.getLogger().println("Distribution completed successfully!");
        }
        return true;
    }

    private static boolean distribute(DistributionBuilder distributionBuilder, ArtifactoryManager artifactoryManager, TaskListener listener, String buildName, String buildNumber, boolean dryRun) {
        try {
            artifactoryManager.distributeBuild(buildName, buildNumber, distributionBuilder.dryRun(dryRun).build());
            return true;
        }
        catch (IOException e) {
            if (dryRun) {
                listener.error("Distribution failed during dry run (no change in Artifactory was done). ", new Object[]{e});
            } else {
                listener.error("Distribution failed. View Artifactory logs for more details. ", new Object[]{e});
            }
            return false;
        }
    }
}

