/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.maven;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.ModuleName;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.BuildableItem;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.BuildWrapper;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.maven.transformer.SnapshotNotAllowedException;
import org.jfrog.hudson.AbstractBuildWrapperDescriptor;
import org.jfrog.hudson.ArtifactoryRedeployPublisher;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.maven.MavenModulesExtractor;
import org.jfrog.hudson.release.maven.MavenReleaseAction;
import org.jfrog.hudson.release.maven.MavenReleaseApiAction;
import org.jfrog.hudson.release.maven.PomTransformer;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.release.scm.AbstractScmCoordinator;
import org.jfrog.hudson.release.scm.ScmCoordinator;
import org.jfrog.hudson.release.scm.git.GitCoordinator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class MavenReleaseWrapper
extends BuildWrapper {
    private static final Logger debuggingLogger = Logger.getLogger(MavenReleaseWrapper.class.getName());
    private String tagPrefix;
    private String releaseBranchPrefix;
    private String targetRemoteName;
    private String alternativeGoals;
    private String defaultVersioning;
    private String defaultReleaseStagingRepository;
    private transient ScmCoordinator scmCoordinator;
    private boolean useReleaseBranch;
    private List<String> mavenModules = new ArrayList<String>();
    private final String POM_NAME = "pom.xml";

    @DataBoundConstructor
    public MavenReleaseWrapper(String releaseBranchPrefix, String tagPrefix, String targetRemoteName, String alternativeGoals, String defaultVersioning, String defaultReleaseStagingRepository, boolean useReleaseBranch) {
        this.releaseBranchPrefix = releaseBranchPrefix;
        this.tagPrefix = tagPrefix;
        this.targetRemoteName = targetRemoteName;
        this.alternativeGoals = alternativeGoals;
        this.defaultVersioning = defaultVersioning;
        this.defaultReleaseStagingRepository = defaultReleaseStagingRepository;
        this.useReleaseBranch = useReleaseBranch;
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = tagPrefix;
    }

    public String getTargetRemoteName() {
        return this.targetRemoteName;
    }

    public void setTargetRemoteName(String targetRemoteName) {
        this.targetRemoteName = targetRemoteName;
    }

    public String getReleaseBranchPrefix() {
        return this.releaseBranchPrefix;
    }

    public void setReleaseBranchPrefix(String releaseBranchPrefix) {
        this.releaseBranchPrefix = releaseBranchPrefix;
    }

    public String getAlternativeGoals() {
        return this.alternativeGoals;
    }

    public void setAlternativeGoals(String alternativeGoals) {
        this.alternativeGoals = alternativeGoals;
    }

    public String getDefaultVersioning() {
        return this.defaultVersioning;
    }

    public void setDefaultVersioning(String defaultVersioning) {
        this.defaultVersioning = defaultVersioning;
    }

    public String getDefaultReleaseStagingRepository() {
        return this.defaultReleaseStagingRepository;
    }

    public void setDefaultReleaseStagingRepository(String defaultReleaseStagingRepository) {
        this.defaultReleaseStagingRepository = defaultReleaseStagingRepository;
    }

    public boolean isUseReleaseBranch() {
        return this.useReleaseBranch;
    }

    public void setUseReleaseBranch(boolean useReleaseBranch) {
        this.useReleaseBranch = useReleaseBranch;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        final ReleaseAction releaseAction = (ReleaseAction)build.getAction(ReleaseAction.class);
        if (releaseAction == null) {
            return new BuildWrapper.Environment(){};
        }
        this.log(listener, "Release build triggered");
        final MavenModuleSetBuild mavenBuild = (MavenModuleSetBuild)build;
        this.mavenModules = this.getMavenModules(mavenBuild);
        this.scmCoordinator = AbstractScmCoordinator.createScmCoordinator(build, listener, releaseAction);
        this.scmCoordinator.prepare();
        if (!releaseAction.getVersioning().equals((Object)ReleaseAction.VERSIONING.NONE)) {
            boolean modified;
            try {
                if (this.scmCoordinator instanceof GitCoordinator) {
                    ((GitCoordinator)this.scmCoordinator).pushDryRun();
                }
            }
            catch (Exception e) {
                this.log(listener, "ERROR: " + e.getMessage());
                return null;
            }
            this.scmCoordinator.beforeReleaseVersionChange();
            String vcsUrl = releaseAction.isCreateVcsTag() && AbstractScmCoordinator.isSvn(build.getProject()) ? releaseAction.getTagUrl() : null;
            try {
                this.log(listener, "Ch\u05b9anging POMs to release version");
                modified = this.changeVersions(mavenBuild, releaseAction, true, vcsUrl);
            }
            catch (SnapshotNotAllowedException e) {
                this.log(listener, "ERROR: " + e.getMessage());
                return null;
            }
            this.scmCoordinator.afterReleaseVersionChange(modified);
        }
        final MavenModuleSet mavenModuleSet = (MavenModuleSet)mavenBuild.getProject();
        final String originalGoals = mavenModuleSet.getGoals();
        if (!StringUtils.isBlank((CharSequence)this.alternativeGoals)) {
            debuggingLogger.fine("Using alternative goals and settings: " + this.alternativeGoals);
            mavenModuleSet.setGoals(this.alternativeGoals);
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (!StringUtils.isBlank((CharSequence)MavenReleaseWrapper.this.alternativeGoals)) {
                    mavenModuleSet.setGoals(originalGoals);
                }
                if (build.getResult().isWorseThan(Result.SUCCESS)) {
                    return true;
                }
                try {
                    MavenReleaseWrapper.this.scmCoordinator.afterSuccessfulReleaseVersionBuild();
                    if (!releaseAction.getVersioning().equals((Object)ReleaseAction.VERSIONING.NONE)) {
                        MavenReleaseWrapper.this.scmCoordinator.beforeDevelopmentVersionChange();
                        String scmUrl = releaseAction.isCreateVcsTag() && AbstractScmCoordinator.isSvn(build.getProject()) ? MavenReleaseWrapper.this.scmCoordinator.getRemoteUrlForPom() : null;
                        MavenReleaseWrapper.this.log(listener, "Changing POMs to next development version");
                        boolean modified = MavenReleaseWrapper.this.changeVersions(mavenBuild, releaseAction, false, scmUrl);
                        MavenReleaseWrapper.this.scmCoordinator.afterDevelopmentVersionChange(modified);
                    }
                }
                catch (Exception e) {
                    listener.getLogger().println("Failure in post build SCM action: " + e.getMessage());
                    debuggingLogger.log(Level.FINE, "Failure in post build SCM action: ", e);
                    return false;
                }
                return true;
            }
        };
    }

    private List<String> getMavenModules(MavenModuleSetBuild mavenBuild) throws IOException, InterruptedException {
        FilePath pathToModuleRoot = mavenBuild.getModuleRoot();
        FilePath pathToPom = new FilePath(pathToModuleRoot, ((MavenModuleSet)mavenBuild.getProject()).getRootPOM(null));
        return (List)pathToPom.act((FilePath.FileCallable)new MavenModulesExtractor());
    }

    private boolean changeVersions(MavenModuleSetBuild mavenBuild, ReleaseAction release, boolean releaseVersion, String scmUrl) throws IOException, InterruptedException {
        FilePath moduleRoot = mavenBuild.getModuleRoot();
        List modules = ((MavenModuleSet)mavenBuild.getProject()).getDisabledModules(false);
        HashMap<ModuleName, String> modulesByName = new HashMap<ModuleName, String>();
        for (MavenModule module : modules) {
            String version = releaseVersion ? release.getReleaseVersionFor(module.getModuleName()) : release.getNextVersionFor(module.getModuleName());
            modulesByName.put(module.getModuleName(), version);
        }
        boolean modified = false;
        for (MavenModule mavenModule : modules) {
            FilePath pomPath = new FilePath(moduleRoot, this.getRelativePomPath(mavenModule, mavenBuild));
            debuggingLogger.fine("Changing version of pom: " + pomPath);
            this.scmCoordinator.edit(pomPath);
            modified |= ((Boolean)pomPath.act((FilePath.FileCallable)new PomTransformer(mavenModule.getModuleName(), modulesByName, scmUrl, releaseVersion))).booleanValue();
        }
        return modified;
    }

    private String getRelativePomPath(MavenModule mavenModule, MavenModuleSetBuild mavenBuild) {
        String relativePath = mavenModule.getRelativePath();
        if (StringUtils.isBlank((CharSequence)relativePath)) {
            return "pom.xml";
        }
        if (mavenModule.getModuleName().toString().equals(((MavenModuleSet)mavenBuild.getProject()).getRootModule().getModuleName().toString())) {
            return ((MavenModuleSet)mavenBuild.getProject()).getRootPOM(null);
        }
        String modulePath = relativePath.substring(relativePath.indexOf("/") + 1);
        for (String moduleName : this.mavenModules) {
            if (!moduleName.contains(modulePath)) continue;
            return this.createPomPath(relativePath, moduleName);
        }
        return relativePath + "/" + "pom.xml";
    }

    private String createPomPath(String relativePath, String moduleName) {
        if (!moduleName.contains(".xml")) {
            return relativePath + "/" + "pom.xml";
        }
        String dirName = relativePath.substring(0, relativePath.indexOf("/"));
        return dirName + "/" + moduleName;
    }

    private void log(BuildListener listener, String message) {
        listener.getLogger().println("[RELEASE] " + message);
    }

    public Collection<? extends Action> getProjectActions(AbstractProject job) {
        MavenModuleSet moduleSet = (MavenModuleSet)job;
        return Arrays.asList(new MavenReleaseAction(moduleSet), new MavenReleaseApiAction(moduleSet));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class ReleaseRunListener
    extends RunListener<AbstractBuild> {
        public void onCompleted(AbstractBuild run, TaskListener listener) {
            if (!(run instanceof MavenModuleSetBuild)) {
                return;
            }
            ReleaseAction releaseAction = (ReleaseAction)run.getAction(ReleaseAction.class);
            if (releaseAction == null) {
                return;
            }
            MavenModuleSet project = (MavenModuleSet)((MavenModuleSetBuild)run).getProject();
            ArtifactoryRedeployPublisher redeployPublisher = ActionableHelper.getPublisher(project, ArtifactoryRedeployPublisher.class);
            Result result = run.getResult();
            boolean successRun = result.isBetterOrEqualTo(Result.SUCCESS);
            if (successRun && !redeployPublisher.isAllowPromotionOfNonStagedBuilds()) {
                run.addAction((Action)new UnifiedPromoteBuildAction((Run<?, ?>)run, redeployPublisher, ""));
            }
            MavenReleaseWrapper wrapper = ActionableHelper.getBuildWrapper((BuildableItem)project, MavenReleaseWrapper.class);
            try {
                wrapper.scmCoordinator.buildCompleted();
            }
            catch (Exception e) {
                run.setResult(Result.FAILURE);
                listener.error("[RELEASE] Failed on build completion");
                listener.getLogger().println(e);
            }
            run.removeAction((Action)releaseAction);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractBuildWrapperDescriptor {
        private static final String DISPLAY_NAME = "Enable Artifactory release management";

        public DescriptorImpl() {
            super(MavenReleaseWrapper.class, DISPLAY_NAME, "");
        }

        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            this.item = item;
            Class<?> itemClass = item.getClass();
            return item instanceof MavenModuleSet || "PromotionProcess".equals(itemClass.getSimpleName());
        }

        @Override
        public boolean configure(StaplerRequest req, JSONObject json) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/artifactory/help/release/common/help-releaseManagement.html";
        }

        public ListBoxModel doFillDefaultVersioningItems() {
            ListBoxModel model = new ListBoxModel();
            for (ReleaseAction.VERSIONING versioning : ReleaseAction.VERSIONING.values()) {
                model.add(versioning.getDisplayMessage(), versioning.toString());
            }
            return model;
        }
    }
}

