/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.maven;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.jfrog.build.extractor.maven.reader.ModuleName;

public class PomTransformer
extends MasterToSlaveFileCallable<Boolean> {
    private final String scmUrl;
    private final hudson.maven.ModuleName currentModule;
    private final Map<hudson.maven.ModuleName, String> versionsByModule;
    private final boolean failOnSnapshot;

    public PomTransformer(hudson.maven.ModuleName currentModule, Map<hudson.maven.ModuleName, String> versionsByModule, String scmUrl, boolean failOnSnapshot) {
        this.currentModule = currentModule;
        this.versionsByModule = versionsByModule;
        this.scmUrl = scmUrl;
        this.failOnSnapshot = failOnSnapshot;
    }

    public Boolean invoke(File pomFile, VirtualChannel channel) throws IOException, InterruptedException {
        ModuleName current = new ModuleName(this.currentModule.groupId, this.currentModule.artifactId);
        LinkedHashMap<ModuleName, String> modules = new LinkedHashMap<ModuleName, String>();
        for (Map.Entry<hudson.maven.ModuleName, String> entry : this.versionsByModule.entrySet()) {
            modules.put(new ModuleName(entry.getKey().groupId, entry.getKey().artifactId), entry.getValue());
        }
        org.jfrog.build.extractor.maven.transformer.PomTransformer transformer = new org.jfrog.build.extractor.maven.transformer.PomTransformer(current, modules, this.scmUrl, this.failOnSnapshot);
        return transformer.transform(pomFile);
    }
}

