/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.promotion;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.BuildBadgeAction;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.builder.PromotionBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.ArtifactoryPlugin;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.release.PromotionUtils;
import org.jfrog.hudson.release.promotion.LoadBuildsResponse;
import org.jfrog.hudson.release.promotion.PromotionConfig;
import org.jfrog.hudson.release.promotion.PromotionInfo;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.ProxyUtils;
import org.jfrog.hudson.util.SerializationUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class UnifiedPromoteBuildAction
extends TaskAction
implements BuildBadgeAction {
    private final Run<?, ?> build;
    private final Map<String, PromotionInfo> promotionCandidates = new ConcurrentHashMap<String, PromotionInfo>();
    private String targetStatus;
    private String targetRepositoryKey;
    private String sourceRepositoryKey;
    private String comment;
    private boolean useCopy;
    private boolean failFast = true;
    private boolean includeDependencies;
    private PluginSettings promotionPlugin;

    public UnifiedPromoteBuildAction(Run<?, ?> build) {
        this.build = build;
    }

    public UnifiedPromoteBuildAction(Run<?, ?> build, BuildInfoAwareConfigurator configurator, String project) {
        this(build);
        String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(configurator, build);
        String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        PromotionConfig promotionConfig = new PromotionConfig();
        promotionConfig.setBuildName(buildName);
        promotionConfig.setBuildNumber(buildNumber);
        promotionConfig.setProject(project);
        this.addPromotionCandidate(promotionConfig, configurator, null);
    }

    public void addPromotionCandidate(PromotionConfig promotionConfig, BuildInfoAwareConfigurator configurator, String displayName) {
        PromotionInfo promotionCandidate = new PromotionInfo(promotionConfig, configurator, this.promotionCandidates.size(), displayName);
        this.promotionCandidates.put(promotionCandidate.getId(), promotionCandidate);
    }

    private BuildInfoAwareConfigurator getFirstConfigurator() {
        return this.promotionCandidates.get("0").getConfigurator();
    }

    private PromotionInfo getPromotionCandidate(String id) {
        return this.promotionCandidates.get(id);
    }

    private String getDefaultPromotionTargetRepository() {
        BuildInfoAwareConfigurator configurator = this.getFirstConfigurator();
        return configurator != null ? configurator.getDefaultPromotionTargetRepository() : "";
    }

    public List<PromotionInfo> getPromotionCandidates() {
        return new ArrayList<PromotionInfo>(this.promotionCandidates.values());
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"})
    public String getBuildsData() {
        try {
            return SerializationUtils.createMapper().writeValueAsString((Object)this.loadBuilds());
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private LoadBuildsResponse loadBuilds() {
        LoadBuildsResponse response = new LoadBuildsResponse();
        this.setPromotionPlugin(null);
        try {
            List<String> repositoryKeys = this.getRepositoryKeys();
            List<UserPluginInfo> plugins = this.getPromotionsUserPluginInfo();
            response.addRepositories(repositoryKeys);
            response.setPlugins(plugins);
            response.setPromotionConfigs(this.getPromotionConfigs(repositoryKeys));
            response.setSuccess(true);
        }
        catch (Exception e) {
            String message = e.getMessage().replace("\n", " ").replace("\"", "");
            response.setResponseMessage(message);
        }
        return response;
    }

    protected Permission getPermission() {
        return ArtifactoryPlugin.PROMOTE;
    }

    public String getIconFileName() {
        return "/plugin/artifactory/images/artifactory-promote.png";
    }

    public String getDisplayName() {
        return "Artifactory Release Promotion";
    }

    public String getUrlName() {
        if (this.hasPromotionPermission()) {
            return "promote";
        }
        return null;
    }

    public boolean hasPromotionPermission() {
        return this.getACL().hasPermission(this.getPermission());
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public void setTargetStatus(String targetStatus) {
        this.targetStatus = targetStatus;
    }

    public void setTargetRepositoryKey(String targetRepositoryKey) {
        this.targetRepositoryKey = targetRepositoryKey;
    }

    public String getSourceRepositoryKey() {
        return this.sourceRepositoryKey;
    }

    public void setSourceRepositoryKey(String sourceRepositoryKey) {
        this.sourceRepositoryKey = sourceRepositoryKey;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setUseCopy(boolean useCopy) {
        this.useCopy = useCopy;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public String getPromotionPluginName() {
        return this.promotionPlugin != null ? this.promotionPlugin.getPluginName() : null;
    }

    public void setPromotionPlugin(PluginSettings promotionPlugin) {
        this.promotionPlugin = promotionPlugin;
    }

    public String getPluginParamValue(String pluginName, String paramKey) {
        return this.promotionPlugin != null ? this.promotionPlugin.getPluginParamValue(pluginName, paramKey) : null;
    }

    public List<String> getTargetStatuses() {
        ArrayList<String> targetStatuses = new ArrayList<String>();
        Collections.addAll(targetStatuses, "Released", "Rolled-back");
        return targetStatuses;
    }

    public List<String> getRepositoryKeys() throws IOException {
        BuildInfoAwareConfigurator configurator = this.getFirstConfigurator();
        if (configurator == null) {
            return new ArrayList<String>();
        }
        ArtifactoryServer artifactoryServer = configurator.getArtifactoryServer();
        if (artifactoryServer == null) {
            return new ArrayList<String>();
        }
        List<String> repos = artifactoryServer.getReleaseRepositoryKeysFirst((DeployerOverrider)((Object)configurator), (Item)this.build.getParent());
        repos.add(0, "");
        return repos;
    }

    public List<PromotionConfig> getPromotionConfigs(List<String> repoKeys) {
        String defaultTargetRepo = this.getDefaultPromotionTargetRepository();
        boolean setTargetRepo = StringUtils.isNotBlank((CharSequence)defaultTargetRepo) && repoKeys.contains(defaultTargetRepo);
        ArrayList<PromotionConfig> configs = new ArrayList<PromotionConfig>();
        for (PromotionInfo info : this.getPromotionCandidates()) {
            PromotionConfig config = info.getPromotionConfig();
            config.setId(info.getId());
            if (setTargetRepo) {
                config.setTargetRepo(defaultTargetRepo);
            }
            configs.add(config);
        }
        return configs;
    }

    public int getPromoteInfoListSize() {
        return this.promotionCandidates.size();
    }

    public String lastPromotionSourceRepository() {
        return this.sourceRepositoryKey;
    }

    public void doIndex(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        req.getView((Object)this, this.chooseAction()).forward((ServletRequest)req, (ServletResponse)resp);
    }

    @RequirePOST
    public void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        req.bindParameters((Object)this);
        User user = User.current();
        String ciUser = user == null ? "anonymous" : user.getId();
        JSONObject formData = req.getSubmittedForm();
        if (formData.has("promotionPlugin")) {
            this.configurePromotionPlugin(formData, ciUser);
        }
        String configuratorId = (String)formData.getOrDefault((Object)"promotionCandidates", (Object)"0");
        PromotionInfo promotionCandidate = this.getPromotionCandidate(configuratorId);
        BuildInfoAwareConfigurator configurator = promotionCandidate.getConfigurator();
        ArtifactoryServer server = configurator.getArtifactoryServer();
        new PromoteWorkerThread(promotionCandidate, CredentialManager.getPreferredDeployer((DeployerOverrider)((Object)configurator), server), ciUser).start();
        resp.sendRedirect(".");
    }

    private void configurePromotionPlugin(JSONObject formData, String ciUser) {
        String pluginName;
        JSONObject pluginSettings = formData.getJSONObject("promotionPlugin");
        if (pluginSettings.get("includeDependencies") != null) {
            this.setIncludeDependencies(pluginSettings.getBoolean("includeDependencies"));
        }
        if (pluginSettings.get("useCopy") != null) {
            this.setUseCopy(pluginSettings.getBoolean("useCopy"));
        }
        if (pluginSettings.get("failFast") != null) {
            this.setFailFast(pluginSettings.getBoolean("failFast"));
        }
        if (pluginSettings.has("pluginName") && !"None".equals(pluginName = pluginSettings.getString("pluginName"))) {
            PluginSettings settings = new PluginSettings();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            settings.setPluginName(pluginName);
            Map filteredPluginSettings = Maps.filterKeys((Map)pluginSettings, input -> StringUtils.isNotBlank((CharSequence)input) && !"pluginName".equals(input));
            for (Map.Entry settingsEntry : filteredPluginSettings.entrySet()) {
                String key = (String)settingsEntry.getKey();
                paramMap.put(key, pluginSettings.getString(key));
            }
            paramMap.put("ciUser", ciUser);
            settings.setParamMap(paramMap);
            this.setPromotionPlugin(settings);
        }
    }

    private List<UserPluginInfo> getPromotionsUserPluginInfo() {
        BuildInfoAwareConfigurator configurator = this.getFirstConfigurator();
        if (configurator == null) {
            ArrayList<UserPluginInfo> infosToReturn = new ArrayList<UserPluginInfo>();
            infosToReturn.add(UserPluginInfo.NO_PLUGIN);
            return infosToReturn;
        }
        ArtifactoryServer artifactoryServer = configurator.getArtifactoryServer();
        if (artifactoryServer == null) {
            ArrayList<UserPluginInfo> infosToReturn = new ArrayList<UserPluginInfo>();
            infosToReturn.add(UserPluginInfo.NO_PLUGIN);
            return infosToReturn;
        }
        return artifactoryServer.getPromotionsUserPluginInfo((DeployerOverrider)((Object)configurator), (Item)this.build.getParent());
    }

    protected ACL getACL() {
        return this.build.getACL();
    }

    private synchronized String chooseAction() {
        return this.workerThread == null ? "form.jelly" : "progress.jelly";
    }

    public final class PromoteWorkerThread
    extends TaskThread {
        private final PromotionInfo promotionCandidate;
        private final CredentialsConfig deployerConfig;
        private final String ciUser;

        PromoteWorkerThread(PromotionInfo promotionCandidate, CredentialsConfig deployerConfig, String ciUser) {
            super((TaskAction)UnifiedPromoteBuildAction.this, TaskThread.ListenerAndText.forMemory(null));
            this.promotionCandidate = promotionCandidate;
            this.deployerConfig = deployerConfig;
            this.ciUser = ciUser;
        }

        protected void perform(TaskListener listener) {
            long started = System.currentTimeMillis();
            listener.getLogger().println("Promoting build ....");
            ArtifactoryServer server = this.promotionCandidate.getConfigurator().getArtifactoryServer();
            String buildName = this.promotionCandidate.getBuildName();
            String buildNumber = this.promotionCandidate.getBuildNumber();
            try (ArtifactoryManager artifactoryManager = server.createArtifactoryManager(this.deployerConfig.provideCredentials((Item)UnifiedPromoteBuildAction.this.build.getParent()), ProxyUtils.createProxyConfiguration());){
                if (UnifiedPromoteBuildAction.this.promotionPlugin != null && !"None".equals(UnifiedPromoteBuildAction.this.promotionPlugin.getPluginName())) {
                    this.handlePluginPromotion(listener, artifactoryManager, buildName, buildNumber);
                } else {
                    PromotionBuilder promotionBuilder = new PromotionBuilder().status(UnifiedPromoteBuildAction.this.targetStatus).comment(UnifiedPromoteBuildAction.this.comment).ciUser(this.ciUser).targetRepo(UnifiedPromoteBuildAction.this.targetRepositoryKey).sourceRepo(UnifiedPromoteBuildAction.this.sourceRepositoryKey).dependencies(UnifiedPromoteBuildAction.this.includeDependencies).copy(UnifiedPromoteBuildAction.this.useCopy).failFast(UnifiedPromoteBuildAction.this.failFast);
                    PromotionUtils.promoteAndCheckResponse(promotionBuilder.build(), artifactoryManager, listener, buildName, buildNumber, this.promotionCandidate.getProject());
                }
                UnifiedPromoteBuildAction.this.build.save();
                long timeToWait = 2000L - (System.currentTimeMillis() - started);
                if (timeToWait > 0L) {
                    Thread.sleep(timeToWait);
                }
                UnifiedPromoteBuildAction.this.workerThread = null;
            }
            catch (Throwable e) {
                listener.error(e.getMessage());
                listener.getLogger().println(e);
            }
        }

        private void handlePluginPromotion(TaskListener listener, ArtifactoryManager artifactoryManager, String buildName, String buildNumber) throws IOException {
            try {
                artifactoryManager.promotionUserPlugin(UnifiedPromoteBuildAction.this.promotionPlugin.getPluginName(), buildName, buildNumber, UnifiedPromoteBuildAction.this.promotionPlugin.getParamMap());
                listener.getLogger().println("Promotion completed successfully!");
            }
            catch (IOException e) {
                PromotionUtils.onPromotionFailFast(false, UnifiedPromoteBuildAction.this.failFast);
                listener.error("Promotion failed.", new Object[]{e});
            }
        }
    }
}

