/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm.svn;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.scm.AbstractScmCoordinator;
import org.jfrog.hudson.release.scm.svn.SubversionManager;

public class SubversionCoordinator
extends AbstractScmCoordinator {
    private SubversionManager scmManager;
    private boolean tagCreated;
    private final ReleaseAction releaseAction;

    public SubversionCoordinator(AbstractBuild build, BuildListener listener, ReleaseAction releaseAction) {
        super(build, listener);
        this.releaseAction = releaseAction;
    }

    @Override
    public void prepare() throws IOException, InterruptedException {
        this.scmManager = new SubversionManager(this.build, (TaskListener)this.listener);
    }

    @Override
    public void afterSuccessfulReleaseVersionBuild() throws InterruptedException, IOException {
        if (this.releaseAction.isCreateVcsTag()) {
            this.scmManager.createTag(this.releaseAction.getTagUrl(), this.releaseAction.getTagComment());
            this.tagCreated = true;
        }
    }

    @Override
    public void beforeDevelopmentVersionChange() {
    }

    @Override
    public void afterDevelopmentVersionChange(boolean modified) throws IOException, InterruptedException {
        super.afterDevelopmentVersionChange(modified);
        if (modified) {
            this.scmManager.commitWorkingCopy(this.releaseAction.getNextDevelCommitComment());
        }
    }

    @Override
    public void buildCompleted() throws IOException, InterruptedException {
        if (this.build.getResult().isWorseThan(Result.SUCCESS)) {
            this.scmManager.safeRevertWorkingCopy();
            if (this.tagCreated) {
                this.scmManager.safeRevertTag(this.releaseAction.getTagUrl(), this.getRevertTagMessage());
            }
        }
    }

    private String getRevertTagMessage() {
        String tagComment = this.releaseAction.getDefaultVcsConfig().getTagComment();
        if (StringUtils.equals((CharSequence)this.releaseAction.getTagComment(), (CharSequence)tagComment)) {
            return tagComment;
        }
        return "[artifactory-release] Reverting: " + this.releaseAction.getTagComment();
    }

    @Override
    public String getRemoteUrlForPom() {
        return this.scmManager.getRemoteUrl(null);
    }
}

