/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.trigger;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.branch.MultiBranchProject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.trigger.BaseTrigger;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArtifactoryMultibranchTrigger
extends BaseTrigger<MultiBranchProject<?, ?>> {
    @DataBoundConstructor
    public ArtifactoryMultibranchTrigger(ServerDetails details, String paths, String spec, String branches) throws ANTLRException {
        super(spec, paths, branches);
        this.details = details;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="job will be set by jenkins")
    List<BuildableItem> getJobsToTrigger() {
        return this.getJobsToTrigger(((MultiBranchProject)this.job).getAllJobs());
    }

    List<BuildableItem> getJobsToTrigger(Collection<? extends Job> jobs) {
        ArrayList<BuildableItem> jobsToTrigger = new ArrayList<BuildableItem>();
        Set inputBranches = Arrays.stream(StringUtils.split((String)this.branches, (String)";")).map(String::trim).collect(Collectors.toSet());
        boolean triggerAll = inputBranches.isEmpty();
        for (Job job : jobs) {
            if (!triggerAll && !inputBranches.removeIf(inputBranch -> inputBranch.equals(this.getBranchName(branchJob)))) continue;
            jobsToTrigger.add((BuildableItem)job);
        }
        if (!inputBranches.isEmpty()) {
            logger.warning("The following branches do not exist in multibranch pipeline '" + ((MultiBranchProject)Objects.requireNonNull(this.job)).getName() + "': " + String.join((CharSequence)", ", inputBranches));
        }
        return jobsToTrigger;
    }

    String getBranchName(Job<?, ?> branchJob) {
        BranchJobProperty branchJobProperty = (BranchJobProperty)branchJob.getProperty(BranchJobProperty.class);
        return branchJobProperty == null ? "" : branchJobProperty.getBranch().getHead().getName();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BaseTrigger.ArtifactoryTriggerDescriptor {
        public boolean isApplicable(Item item) {
            try {
                return item instanceof MultiBranchProject;
            }
            catch (NoClassDefFoundError ignore) {
                return false;
            }
        }

        @Override
        public List<JFrogPlatformInstance> getJfrogInstances() {
            return super.getJfrogInstances();
        }
    }
}

