/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.trigger;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jfrog.build.client.ItemLastModified;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.trigger.ArtifactoryCause;
import org.jfrog.hudson.trigger.ArtifactoryTriggerInfo;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;
import org.jfrog.hudson.util.RepositoriesUtils;

public abstract class BaseTrigger<JobType extends BuildableItem>
extends Trigger<JobType> {
    static final Logger logger = Logger.getLogger(JenkinsBuildInfoLog.class.getName());
    private long lastModified = System.currentTimeMillis();
    ServerDetails details;
    String branches;
    String paths;

    BaseTrigger(String spec, String paths, String branches) throws ANTLRException {
        super(spec);
        this.paths = StringUtils.trimToEmpty((String)paths);
        this.branches = StringUtils.trimToEmpty((String)branches);
    }

    public void setDetails(ServerDetails details) {
        this.details = details;
    }

    public ServerDetails getDetails() {
        return this.details;
    }

    public String getBranches() {
        return this.branches;
    }

    public String getPaths() {
        return this.paths;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="job will be set by jenkins")
    public void run() {
        if (this.job == null) {
            return;
        }
        ArtifactoryServer server = this.getArtifactoryServer();
        try (ArtifactoryManager artifactoryManager = server.createArtifactoryManager(server.getDeployerCredentialsConfig().provideCredentials(this.job), ProxyUtils.createProxyConfiguration());){
            String[] paths;
            for (String path : paths = this.paths.split(";")) {
                ItemLastModified itemLastModified = artifactoryManager.getItemLastModified(StringUtils.trimToEmpty((String)path));
                long responseLastModified = itemLastModified.getLastModified();
                if (responseLastModified > this.lastModified) {
                    this.lastModified = responseLastModified;
                    for (BuildableItem jobToTrigger : this.getJobsToTrigger()) {
                        logger.fine("Updating " + jobToTrigger.getName());
                        jobToTrigger.save();
                        jobToTrigger.scheduleBuild((Cause)new ArtifactoryCause(itemLastModified.getUri()));
                    }
                    continue;
                }
                logger.fine(String.format("Artifactory Trigger did not trigger job %s, since last modified time: %d is earlier or equal than %d for path %s", ((BuildableItem)this.job).getName(), responseLastModified, this.lastModified, path));
            }
        }
        catch (IOException | ParseException e) {
            logger.severe("Artifactory Trigger encountered an unexpected error:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public void stop() {
        if (this.job == null) {
            return;
        }
        logger.info("Stopping " + ((BuildableItem)this.job).getName() + " Artifactory trigger.");
        super.stop();
    }

    public ArtifactoryServer getArtifactoryServer() {
        if (this.details == null) {
            return null;
        }
        String serverId = this.details.getArtifactoryName();
        return StringUtils.isBlank((CharSequence)serverId) ? this.getArtifactoryServerFromPipeline() : this.getGlobalArtifactoryServer(serverId);
    }

    private ArtifactoryServer getArtifactoryServerFromPipeline() {
        if (!(this.job instanceof WorkflowJob)) {
            return null;
        }
        ArtifactoryTriggerInfo info = (ArtifactoryTriggerInfo)((WorkflowJob)this.job).getAction(ArtifactoryTriggerInfo.class);
        return info != null ? info.getServer() : null;
    }

    private ArtifactoryServer getGlobalArtifactoryServer(String serverId) {
        ArtifactoryServer server = RepositoriesUtils.getArtifactoryServer(serverId);
        if (server == null) {
            this.handleServerNotExist(serverId);
        }
        return server;
    }

    private void handleServerNotExist(String serverId) {
        String message = "Artifactory Trigger failed triggering the job, since Artifactory server ";
        if (StringUtils.isNotBlank((CharSequence)serverId)) {
            message = message + "'" + serverId + "' ";
        }
        message = message + "does not exist.";
        logger.warning(message);
        throw new RuntimeException(message);
    }

    abstract List<BuildableItem> getJobsToTrigger();

    public String getSelectedServerId() {
        return this.details != null ? StringUtils.stripToNull((String)this.details.getArtifactoryName()) : null;
    }

    public List<JFrogPlatformInstance> getJfrogInstances() {
        ArrayList<JFrogPlatformInstance> jfrogInstances = new ArrayList<JFrogPlatformInstance>(RepositoriesUtils.getJFrogPlatformInstances());
        ArtifactoryServer propertyServer = this.getArtifactoryServerFromPipeline();
        if (propertyServer != null) {
            jfrogInstances.add(new JFrogPlatformInstance(propertyServer));
        }
        return jfrogInstances;
    }

    static abstract class ArtifactoryTriggerDescriptor
    extends TriggerDescriptor {
        ArtifactoryTriggerDescriptor() {
        }

        @Nonnull
        public String getDisplayName() {
            return "Enable Artifactory trigger";
        }

        public List<JFrogPlatformInstance> getJfrogInstances() {
            return RepositoriesUtils.getJFrogPlatformInstances();
        }
    }
}

