/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class Credentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Credentials EMPTY_CREDENTIALS = new Credentials("", "", "");
    private final Secret username;
    private final Secret password;
    private final Secret accessToken;

    private Credentials(String username, String password, String accessToken) {
        this.username = Secret.fromString((String)username);
        this.password = Secret.fromString((String)password);
        this.accessToken = Secret.fromString((String)accessToken);
    }

    public Credentials(String accessToken) {
        this("", "", accessToken);
    }

    public Credentials(String username, String password) {
        this(username, password, "");
    }

    public static String extractUsernameFromToken(String accessToken) throws IOException {
        String payload = StringUtils.split((String)accessToken, (char)'.')[1];
        byte[] decodedPayload = Base64.getDecoder().decode(payload);
        String jsonStr = new String(decodedPayload, StandardCharsets.UTF_8);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TokenPayload payloadObject = (TokenPayload)mapper.readValue(jsonStr, TokenPayload.class);
        int usernameStartIndex = payloadObject.sub.lastIndexOf("/") + 1;
        return payloadObject.sub.substring(usernameStartIndex);
    }

    public Credentials convertAccessTokenToUsernamePassword() throws IOException {
        String descrambledToken = Secret.toString((Secret)this.accessToken);
        return new Credentials(Credentials.extractUsernameFromToken(descrambledToken), descrambledToken);
    }

    @DataBoundConstructor
    public Credentials(String username, String password, String resolverUsername, String resolverPassword) {
        if (StringUtils.isNotBlank((CharSequence)resolverUsername) && StringUtils.isNotBlank((CharSequence)resolverPassword)) {
            username = resolverUsername;
            password = resolverPassword;
        }
        this.username = Secret.fromString((String)username);
        this.password = Secret.fromString((String)password);
        this.accessToken = Secret.fromString((String)"");
    }

    public String getUsername() {
        return Secret.toString((Secret)this.username);
    }

    public String getPassword() {
        return Secret.toString((Secret)this.password);
    }

    public String getAccessToken() {
        return Secret.toString((Secret)this.accessToken);
    }

    private static class TokenPayload {
        private String sub;

        private TokenPayload() {
        }

        public void setSub(String sub) {
            this.sub = sub;
        }

        public String getSub() {
            return this.sub;
        }
    }
}

