/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedMapDifference;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.IOUtils;
import hudson.util.RunList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.ci.BuildRetention;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.util.encryption.EncryptionKeyPair;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.maven3.ArtifactoryMaven3Configurator;
import org.jfrog.hudson.maven3.ArtifactoryMaven3NativeConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.resolvers.MavenResolver;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.util.BuildRetentionFactory;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.IssuesTrackerHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ResolverContext;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;

public class ExtractorUtils {
    public static final String EXTRACTOR_USED = "extractor.used";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    public static final String GIT_URL = "GIT_URL";
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_MESSAGE = "GIT_MESSAGE";
    private static final Set<Character> PROPERTIES_SPECIAL_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('|'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('=')));

    private ExtractorUtils() {
        throw new IllegalAccessError();
    }

    public static String getVcsRevision(Map<String, String> env) {
        String revision = env.get("SVN_REVISION");
        if (StringUtils.isBlank((CharSequence)revision)) {
            revision = env.get(GIT_COMMIT);
        }
        if (StringUtils.isBlank((CharSequence)revision)) {
            revision = env.get("P4_CHANGELIST");
        }
        return revision;
    }

    public static String getVcsUrl(Map<String, String> env) {
        String url = env.get("SVN_URL");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = ExtractorUtils.publicGitUrl(env.get(GIT_URL));
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            url = env.get("P4PORT");
        }
        return url;
    }

    public static String getVcsBranch(Map<String, String> env) {
        String branch = env.get(GIT_BRANCH);
        return branch != null ? branch : "";
    }

    public static String getVcsMessage(Map<String, String> env) {
        String message = env.get(GIT_MESSAGE);
        return message != null ? message : "";
    }

    public static void addVcsDetailsToEnv(FilePath filePath, EnvVars env, TaskListener listener) throws IOException, InterruptedException {
        Vcs vcs = Utils.extractVcs(filePath, new JenkinsBuildInfoLog(listener));
        env.put(GIT_COMMIT, (String)StringUtils.defaultIfEmpty((CharSequence)vcs.getRevision(), (CharSequence)""));
        env.put(GIT_URL, (String)StringUtils.defaultIfEmpty((CharSequence)vcs.getUrl(), (CharSequence)""));
        env.put(GIT_BRANCH, ExtractorUtils.escapeProperty((String)StringUtils.defaultIfEmpty((CharSequence)vcs.getBranch(), (CharSequence)"")));
        env.put(GIT_MESSAGE, ExtractorUtils.escapeProperty((String)StringUtils.defaultIfEmpty((CharSequence)vcs.getMessage(), (CharSequence)"")));
    }

    public static String escapeProperty(String property) {
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        for (char c : property.toCharArray()) {
            if (c == '\\') {
                escaped = true;
            } else if (PROPERTIES_SPECIAL_CHARS.contains(Character.valueOf(c)) && !escaped) {
                builder.append("\\");
            } else {
                escaped = false;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static String publicGitUrl(String gitUrl) {
        if (gitUrl != null && gitUrl.contains("https://") && gitUrl.contains("@")) {
            StringBuilder sb = new StringBuilder(gitUrl);
            int start = sb.indexOf("https://");
            int end = sb.indexOf("@") + 1;
            sb = sb.replace(start, end, "");
            return "https://" + sb.toString();
        }
        return gitUrl;
    }

    public static ArtifactoryClientConfiguration addBuilderInfoArguments(Map<String, String> env, Run build, TaskListener listener, PublisherContext publisherContext, ResolverContext resolverContext, FilePath ws, Launcher launcher, boolean skipEncryption) throws Exception {
        ArtifactoryClientConfiguration configuration = ExtractorUtils.getArtifactoryClientConfiguration(env, build, null, listener, publisherContext, resolverContext);
        if (ExtractorUtils.isMavenResolutionConfigured(resolverContext)) {
            env.put("buildInfoConfig.artifactoryResolutionEnabled", Boolean.TRUE.toString());
        }
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(ws);
        ExtractorUtils.persistConfiguration(configuration, env, tempDir, skipEncryption);
        return configuration;
    }

    public static ArtifactoryClientConfiguration getArtifactoryClientConfiguration(Map<String, String> env, Run build, BuildInfo pipelineBuildInfo, TaskListener listener, PublisherContext publisherContext, ResolverContext resolverContext) throws IOException {
        ArtifactoryClientConfiguration configuration = new ArtifactoryClientConfiguration((Log)new NullLog());
        if (build instanceof AbstractBuild) {
            ExtractorUtils.addBuildRootIfNeeded((AbstractBuild)build, configuration);
        }
        if (publisherContext != null || resolverContext != null) {
            ExtractorUtils.setPublisherResolverInfo(env, build, configuration, publisherContext, resolverContext, pipelineBuildInfo);
        }
        if (!ExtractorUtils.shouldBypassProxy(resolverContext, publisherContext)) {
            ExtractorUtils.setProxy(configuration);
        }
        if (Jenkins.get().getPlugin("jira") != null && publisherContext != null && publisherContext.isEnableIssueTrackerIntegration()) {
            new IssuesTrackerHelper(build, listener, publisherContext.isAggregateBuildIssues(), publisherContext.getAggregationBuildStatus()).setIssueTrackerInfo(configuration);
        }
        ExtractorUtils.addEnvVars(env, build, pipelineBuildInfo, publisherContext, configuration, listener);
        return configuration;
    }

    private static void setPublisherResolverInfo(Map<String, String> env, Run<?, ?> build, ArtifactoryClientConfiguration configuration, PublisherContext publisherContext, ResolverContext resolverContext, BuildInfo pipelineBuildInfo) throws IOException {
        String buildName = pipelineBuildInfo != null ? pipelineBuildInfo.getName() : BuildUniqueIdentifierHelper.getBuildName(build);
        configuration.info.setBuildName(buildName);
        String buildNumber = pipelineBuildInfo != null ? pipelineBuildInfo.getNumber() : BuildUniqueIdentifierHelper.getBuildNumber(build);
        configuration.info.setBuildNumber(buildNumber);
        String project = ExtractorUtils.getProject(publisherContext, pipelineBuildInfo);
        configuration.info.setProject(project);
        if (publisherContext != null) {
            ExtractorUtils.setPublisherInfo(env, build, pipelineBuildInfo, publisherContext, configuration, buildName, buildNumber, project);
            publisherContext.setArtifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion());
        }
        if (resolverContext != null) {
            ExtractorUtils.setResolverInfo(configuration, build, resolverContext, env);
        }
    }

    private static String getProject(PublisherContext publisherContext, BuildInfo pipelineBuildInfo) {
        if (pipelineBuildInfo != null) {
            return pipelineBuildInfo.getProject();
        }
        if (publisherContext != null) {
            return publisherContext.getProject();
        }
        return null;
    }

    private static boolean shouldBypassProxy(ResolverContext resolverContext, PublisherContext publisherContext) {
        boolean bypass = resolverContext != null && resolverContext.getServer() != null && resolverContext.getServer().isBypassProxy();
        return bypass || publisherContext != null && publisherContext.getArtifactoryServer() != null && publisherContext.getArtifactoryServer().isBypassProxy();
    }

    private static void setProxy(ArtifactoryClientConfiguration configuration) {
        Jenkins j = Jenkins.get();
        if (j.proxy != null) {
            configuration.proxy.setHost(j.proxy.name);
            configuration.proxy.setPort(Integer.valueOf(j.proxy.port));
            configuration.proxy.setUsername(j.proxy.getUserName());
            configuration.proxy.setPassword(j.proxy.getPassword());
        }
    }

    private static void setResolverInfo(ArtifactoryClientConfiguration configuration, Run build, ResolverContext context, Map<String, String> env) throws IOException {
        configuration.setTimeout(Integer.valueOf(context.getServer().getTimeout()));
        ExtractorUtils.setRetryParams(configuration, context.getServer());
        configuration.resolver.setContextUrl(context.getServerDetails().getArtifactoryUrl());
        String inputDownloadReleaseKey = context.getServerDetails().getResolveReleaseRepository().getRepoKey();
        String inputDownloadSnapshotKey = context.getServerDetails().getResolveSnapshotRepository().getRepoKey();
        ExtractorUtils.replaceRepositoryInputForValues(configuration, build, inputDownloadReleaseKey, inputDownloadSnapshotKey, env);
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(context.getResolverOverrider(), context.getServer());
        Credentials resolverCredentials = preferredResolver.provideCredentials((Item)build.getParent());
        if (StringUtils.isNotEmpty((CharSequence)resolverCredentials.getAccessToken())) {
            resolverCredentials = resolverCredentials.convertAccessTokenToUsernamePassword();
        }
        if (StringUtils.isNotBlank((CharSequence)resolverCredentials.getUsername())) {
            configuration.resolver.setUsername(resolverCredentials.getUsername());
            configuration.resolver.setPassword(resolverCredentials.getPassword());
        }
    }

    private static void replaceRepositoryInputForValues(ArtifactoryClientConfiguration configuration, Run build, String resolverReleaseInput, String resolverSnapshotInput, Map<String, String> env) {
        if (StringUtils.isBlank((CharSequence)resolverReleaseInput) || StringUtils.isBlank((CharSequence)resolverSnapshotInput)) {
            throw new IllegalStateException("Input for resolve repositories cannot be empty.");
        }
        String resolveReleaseRepo = Util.replaceMacro((String)resolverReleaseInput, env);
        String resolveSnapshotRepo = Util.replaceMacro((String)resolverSnapshotInput, env);
        if (StringUtils.isBlank((CharSequence)resolveReleaseRepo) || StringUtils.isBlank((CharSequence)resolveSnapshotRepo)) {
            throw new IllegalStateException("Resolver repository variable cannot be replaces with empty value.");
        }
        configuration.resolver.setDownloadSnapshotRepoKey(resolveSnapshotRepo);
        configuration.resolver.setRepoKey(resolveReleaseRepo);
    }

    private static void setPublisherInfo(Map<String, String> env, Run<?, ?> build, BuildInfo pipelineBuildInfo, PublisherContext context, ArtifactoryClientConfiguration configuration, String buildName, String buildNumber, String project) throws IOException {
        ReleaseAction releaseAction;
        IncludesExcludes deploymentPatterns;
        ServerDetails serverDetails;
        String vcsMessage;
        String vcsBranch;
        String vcsUrl;
        configuration.setActivateRecorder(Boolean.TRUE);
        if (pipelineBuildInfo == null && context.isOverrideBuildName()) {
            buildName = context.getCustomBuildName();
            configuration.info.setBuildName(buildName);
        }
        configuration.publisher.addMatrixParam("build.name", buildName);
        configuration.publisher.addMatrixParam("build.number", buildNumber);
        configuration.publisher.addMatrixParam("build.project", project);
        configuration.info.setArtifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion());
        Date buildStartDate = build.getTimestamp().getTime();
        configuration.info.setBuildStarted(buildStartDate.getTime());
        configuration.info.setBuildTimestamp(String.valueOf(build.getStartTimeInMillis()));
        configuration.publisher.addMatrixParam("build.timestamp", String.valueOf(build.getStartTimeInMillis()));
        String vcsRevision = ExtractorUtils.getVcsRevision(env);
        if (StringUtils.isNotBlank((CharSequence)vcsRevision)) {
            configuration.info.setVcsRevision(vcsRevision);
            configuration.publisher.addMatrixParam("vcs.revision", vcsRevision);
        }
        if (StringUtils.isNotBlank((CharSequence)(vcsUrl = ExtractorUtils.getVcsUrl(env)))) {
            configuration.info.setVcsUrl(vcsUrl);
            configuration.publisher.addMatrixParam("vcs.url", vcsUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(vcsBranch = ExtractorUtils.getVcsBranch(env)))) {
            configuration.info.setVcsBranch(vcsBranch);
            configuration.publisher.addMatrixParam("vcs.branch", vcsBranch);
        }
        if (StringUtils.isNotBlank((CharSequence)(vcsMessage = ExtractorUtils.getVcsMessage(env)))) {
            configuration.info.setVcsBranch(vcsMessage);
            configuration.publisher.addMatrixParam("vcs.message", vcsMessage);
        }
        if (StringUtils.isNotBlank((CharSequence)context.getArtifactsPattern())) {
            configuration.publisher.setIvyArtifactPattern(Util.replaceMacro((String)context.getArtifactsPattern(), env));
        }
        if (StringUtils.isNotBlank((CharSequence)context.getIvyPattern())) {
            configuration.publisher.setIvyPattern(Util.replaceMacro((String)context.getIvyPattern(), env));
        }
        configuration.publisher.setM2Compatible(Boolean.valueOf(context.isMaven2Compatible()));
        String buildUrl = ActionableHelper.getBuildUrl(build);
        if (StringUtils.isNotBlank((CharSequence)buildUrl)) {
            configuration.info.setBuildUrl(buildUrl);
        }
        String userName = null;
        String upstreamProject = ActionableHelper.getUpstreamProject(build);
        if (StringUtils.isNotBlank((CharSequence)project)) {
            String parentProject = ExtractorUtils.sanitizeBuildName(upstreamProject);
            configuration.info.setParentBuildName(parentProject);
            configuration.publisher.addMatrixParam("build.parentName", parentProject);
            Integer upstreamBuild = ActionableHelper.getUpstreamBuild(build);
            if (upstreamBuild != null) {
                String parentBuildNumber = upstreamBuild + "";
                configuration.info.setParentBuildNumber(parentBuildNumber);
                configuration.publisher.addMatrixParam("build.parentNumber", parentBuildNumber);
            }
            userName = "auto";
        }
        userName = ActionableHelper.getUserCausePrincipal(build, userName);
        configuration.info.setPrincipal(userName);
        configuration.info.setAgentName("Jenkins");
        configuration.info.setAgentVersion(Jenkins.VERSION);
        ArtifactoryServer artifactoryServer = context.getArtifactoryServer();
        if (artifactoryServer != null) {
            CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(context.getDeployerOverrider(), artifactoryServer);
            Credentials deployerCredentials = preferredDeployer.provideCredentials((Item)build.getParent());
            if (StringUtils.isNotEmpty((CharSequence)deployerCredentials.getAccessToken())) {
                deployerCredentials = deployerCredentials.convertAccessTokenToUsernamePassword();
            }
            if (StringUtils.isNotBlank((CharSequence)deployerCredentials.getUsername())) {
                configuration.publisher.setUsername(deployerCredentials.getUsername());
                configuration.publisher.setPassword(deployerCredentials.getPassword());
            }
            configuration.setTimeout(Integer.valueOf(artifactoryServer.getTimeout()));
            ExtractorUtils.setRetryParams(configuration, artifactoryServer);
            configuration.publisher.setContextUrl(artifactoryServer.getArtifactoryUrl());
        }
        if ((serverDetails = context.getServerDetails()) != null) {
            String inputRepKey = serverDetails.getDeployReleaseRepositoryKey();
            String repoKEy = Util.replaceMacro((String)inputRepKey, env);
            configuration.publisher.setRepoKey(repoKEy);
            String inputSnapshotRepKey = serverDetails.getDeploySnapshotRepositoryKey();
            String snapshotRepoKey = Util.replaceMacro((String)inputSnapshotRepKey, env);
            configuration.publisher.setSnapshotRepoKey(snapshotRepoKey);
        }
        if (context.isDiscardOldBuilds()) {
            BuildRetention buildRetention = BuildRetentionFactory.createBuildRetention(build, context.isDiscardBuildArtifacts());
            if (buildRetention.getCount() > -1) {
                configuration.info.setBuildRetentionCount(Integer.valueOf(buildRetention.getCount()));
            }
            if (buildRetention.getMinimumBuildDate() != null) {
                long days = ExtractorUtils.daysBetween(buildRetention.getMinimumBuildDate(), new Date());
                configuration.info.setBuildRetentionMinimumDate(String.valueOf(days));
            }
            configuration.info.setDeleteBuildArtifacts(Boolean.valueOf(context.isDiscardBuildArtifacts()));
            configuration.info.setAsyncBuildRetention(Boolean.valueOf(context.isAsyncBuildRetention()));
            configuration.info.setBuildNumbersNotToDelete(ExtractorUtils.getBuildNumbersNotToBeDeletedAsString(build));
        }
        configuration.publisher.setPublishArtifacts(Boolean.valueOf(context.isDeployArtifacts()));
        configuration.publisher.setPublishForkCount(context.getThreads());
        configuration.publisher.setEvenUnstable(Boolean.valueOf(context.isEvenIfUnstable()));
        if (context.isDeployIvy() != null) {
            configuration.publisher.setIvy(context.isDeployIvy());
        }
        if (context.isDeployMaven() != null) {
            configuration.publisher.setMaven(context.isDeployMaven().booleanValue());
        }
        if ((deploymentPatterns = context.getIncludesExcludes()) != null) {
            String excludePatterns;
            String includePatterns = deploymentPatterns.getIncludePatterns();
            if (StringUtils.isNotBlank((CharSequence)includePatterns)) {
                configuration.publisher.setIncludePatterns(Util.replaceMacro((String)includePatterns, env));
            }
            if (StringUtils.isNotBlank((CharSequence)(excludePatterns = deploymentPatterns.getExcludePatterns()))) {
                configuration.publisher.setExcludePatterns(Util.replaceMacro((String)excludePatterns, env));
            }
        }
        if ((releaseAction = ActionableHelper.getLatestAction(build, ReleaseAction.class)) != null) {
            configuration.info.setReleaseEnabled(Boolean.valueOf(true));
            String comment = releaseAction.getStagingComment();
            if (StringUtils.isNotBlank((CharSequence)comment)) {
                configuration.info.setReleaseComment(comment);
            }
        }
        configuration.publisher.setFilterExcludedArtifactsFromBuild(context.isFilterExcludedArtifactsFromBuild());
        configuration.publisher.setPublishBuildInfo(Boolean.valueOf(!context.isSkipBuildInfoDeploy()));
        configuration.publisher.setRecordAllDependencies(Boolean.valueOf(context.isRecordAllDependencies()));
        List<String> gradlePublications = context.getGradlePublications();
        if (gradlePublications != null) {
            String publications = String.join((CharSequence)",", gradlePublications);
            configuration.publisher.setPublications(publications);
        }
        ExtractorUtils.addDeploymentProperties(context, configuration.publisher, env);
    }

    private static void setRetryParams(ArtifactoryClientConfiguration configuration, ArtifactoryServer artifactoryServer) {
        configuration.setConnectionRetries(Integer.valueOf(artifactoryServer.getConnectionRetry()));
    }

    private static long daysBetween(Date date1, Date date2) {
        long diff = date2.after(date1) ? date2.getTime() - date1.getTime() : date1.getTime() - date2.getTime();
        return diff / 86400000L;
    }

    public static String sanitizeBuildName(String buildName) {
        String s = StringUtils.replace((String)buildName, (String)"/", (String)" :: ");
        return StringUtils.replace((String)s, (String)"%2F", (String)" :: ");
    }

    public static List<String> getBuildNumbersNotToBeDeleted(Run build) {
        ArrayList<String> notToDelete = new ArrayList<String>();
        RunList builds = build.getParent().getBuilds();
        for (Run run : builds) {
            if (!run.isKeepLog()) continue;
            notToDelete.add(String.valueOf(run.getNumber()));
        }
        return notToDelete;
    }

    private static String getBuildNumbersNotToBeDeletedAsString(Run build) {
        StringBuilder builder = new StringBuilder();
        List<String> notToBeDeleted = ExtractorUtils.getBuildNumbersNotToBeDeleted(build);
        for (String notToDelete : notToBeDeleted) {
            builder.append(notToDelete).append(",");
        }
        return builder.toString();
    }

    public static void addBuildRootIfNeeded(AbstractBuild build, ArtifactoryClientConfiguration configuration) throws UnsupportedEncodingException {
        AbstractBuild<?, ?> rootBuild = BuildUniqueIdentifierHelper.getRootBuild(build);
        if (rootBuild != null) {
            String identifier = BuildUniqueIdentifierHelper.getUpstreamIdentifier(rootBuild);
            configuration.info.setBuildRoot(identifier);
        }
    }

    public static void persistConfiguration(ArtifactoryClientConfiguration configuration, Map<String, String> env, FilePath ws, boolean skipEncryption) throws IOException, InterruptedException {
        FilePath propertiesFile = ExtractorUtils.createPropertiesFile(ws);
        ExtractorUtils.setPersistConfigurationEnv(configuration, propertiesFile, env);
        ExtractorUtils.savePropertiesToFile(configuration, propertiesFile, env, skipEncryption);
    }

    private static FilePath createPropertiesFile(FilePath ws) throws IOException, InterruptedException {
        FilePath propertiesFile = ws.createTextTempFile("buildInfo", ".properties", "");
        ActionableHelper.deleteFilePathOnExit(propertiesFile);
        return propertiesFile;
    }

    private static void setPersistConfigurationEnv(ArtifactoryClientConfiguration configuration, FilePath propertiesFile, Map<String, String> env) {
        configuration.setPropertiesFile(propertiesFile.getRemote());
        env.put("BUILDINFO_PROPFILE", propertiesFile.getRemote());
        env.put("buildInfoConfig.propertiesFile", propertiesFile.getRemote());
        System.setProperty("buildInfoConfig.propertiesFile", propertiesFile.getRemote());
    }

    private static void savePropertiesToFile(ArtifactoryClientConfiguration configuration, FilePath propertiesFile, Map<String, String> env, boolean skipEncryption) {
        try (OutputStream outputStream = propertiesFile.write();){
            if (skipEncryption) {
                configuration.persistToPropertiesFile(outputStream);
            } else {
                EncryptionKeyPair keyPair = configuration.persistToEncryptedPropertiesFile(outputStream);
                env.put("PROPERTIES_FILE_KEY", keyPair.getStringSecretKey());
                env.put("PROPERTIES_FILE_KEY_IV", keyPair.getStringIv());
            }
        }
        catch (IOException | InterruptedException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addDeploymentProperties(PublisherContext context, ArtifactoryClientConfiguration.PublisherHandler publisher, Map<String, String> env) {
        String deploymentProperties = Util.replaceMacro((String)context.getDeploymentProperties(), env);
        ArrayListMultimap params = ArrayListMultimap.create();
        SpecsHelper.fillPropertiesMap((String)deploymentProperties, (ArrayListMultimap)params);
        publisher.addMatrixParams(params);
    }

    private static void addEnvVars(Map<String, String> env, Run<?, ?> build, BuildInfo pipelineBuildInfo, PublisherContext publisherContext, ArtifactoryClientConfiguration configuration, TaskListener listener) {
        IncludeExcludePatterns patterns = ExtractorUtils.setAndGetEnvPatterns(pipelineBuildInfo, publisherContext, env, configuration);
        MapDifference envDifference = Maps.difference(env, System.getenv());
        Map filteredEnvDifference = envDifference.entriesOnlyOnLeft();
        configuration.info.addBuildVariables(filteredEnvDifference, patterns);
        EnvVars buildVariables = ExtractorUtils.getEnvVars(build, listener);
        SortedMapDifference buildVarDifference = Maps.difference((SortedMap)buildVariables, System.getenv());
        Map filteredBuildVarDifferences = buildVarDifference.entriesOnlyOnLeft();
        configuration.info.addBuildVariables(filteredBuildVarDifferences, patterns);
        configuration.fillFromProperties((Map)buildVariables, patterns);
        for (Map.Entry entry : buildVariables.entrySet()) {
            if (!((String)entry.getKey()).startsWith("deploy.")) continue;
            configuration.publisher.addMatrixParam((String)entry.getKey(), (String)entry.getValue());
        }
        MultiConfigurationUtils.addMatrixCombination(build, configuration);
    }

    private static IncludeExcludePatterns setAndGetEnvPatterns(@Nullable BuildInfo pipelineBuildInfo, @Nullable PublisherContext publisherContext, Map<String, String> env, ArtifactoryClientConfiguration configuration) {
        IncludesExcludes includesExcludes;
        if (pipelineBuildInfo != null) {
            includesExcludes = Utils.getArtifactsIncludeExcludeForDeyployment(pipelineBuildInfo.getEnv().getFilter().getPatternFilter());
            configuration.setIncludeEnvVars(Boolean.valueOf(pipelineBuildInfo.getEnv().isCapture()));
        } else if (publisherContext != null && publisherContext.getEnvVarsPatterns() != null) {
            includesExcludes = publisherContext.getEnvVarsPatterns();
            configuration.setIncludeEnvVars(Boolean.valueOf(publisherContext.isIncludeEnvVars()));
        } else {
            return new IncludeExcludePatterns("", "");
        }
        String includePatterns = Util.replaceMacro((String)includesExcludes.getIncludePatterns(), env);
        String excludePatterns = Util.replaceMacro((String)includesExcludes.getExcludePatterns(), env);
        configuration.setEnvVarsIncludePatterns(includePatterns);
        configuration.setEnvVarsExcludePatterns(excludePatterns);
        return new IncludeExcludePatterns(includePatterns, excludePatterns);
    }

    private static EnvVars getEnvVars(Run<?, ?> build, TaskListener listener) {
        EnvVars buildVariables;
        if (build instanceof AbstractBuild) {
            buildVariables = new EnvVars();
            buildVariables.putAll(((AbstractBuild)build).getBuildVariables());
        } else {
            buildVariables = Utils.extractBuildParameters(build, listener);
        }
        return buildVariables;
    }

    public static String entityToString(HttpEntity entity) throws IOException {
        if (entity != null) {
            InputStream is = entity.getContent();
            return IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        return "";
    }

    public static void validateStringNotBlank(String content) throws IOException {
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new IOException("Received empty String.");
        }
    }

    private static boolean isMavenResolutionConfigured(ResolverContext resolverContext) {
        return resolverContext != null && resolverContext.getResolverOverrider() != null && (resolverContext.getResolverOverrider() instanceof ArtifactoryMaven3Configurator || resolverContext.getResolverOverrider() instanceof ArtifactoryMaven3NativeConfigurator || resolverContext.getResolverOverrider() instanceof MavenResolver);
    }

    public static FilePath createAndGetTempDir(final FilePath ws) throws IOException, InterruptedException {
        final String workspaceList = System.getProperty("hudson.slaves.WorkspaceList");
        return (FilePath)ws.act((Callable)new MasterToSlaveCallable<FilePath, IOException>(){

            public FilePath call() {
                FilePath tempDir = ws.sibling(ws.getName() + Objects.toString(workspaceList, "@") + "tmp").child("artifactory");
                File tempDirFile = new File(tempDir.getRemote());
                if (tempDirFile.mkdirs()) {
                    tempDirFile.deleteOnExit();
                }
                return tempDir;
            }
        });
    }
}

