/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Item;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.ArtifactoryBuilder;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ResolutionRepository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ProxyUtils;

public abstract class RepositoriesUtils {
    public static List<String> getReleaseRepositoryKeysFirst(DeployerOverrider deployer, ArtifactoryServer server) throws IOException {
        if (server == null) {
            return new ArrayList<String>();
        }
        return server.getReleaseRepositoryKeysFirst(deployer, null);
    }

    public static List<String> getSnapshotRepositoryKeysFirst(DeployerOverrider deployer, ArtifactoryServer server) throws IOException {
        if (server == null) {
            return new ArrayList<String>();
        }
        return server.getSnapshotRepositoryKeysFirst(deployer, null);
    }

    public static List<ResolutionRepository> getResolutionRepositoryKeys(ResolverOverrider resolverOverrider, DeployerOverrider deployerOverrider, ArtifactoryServer server) {
        if (server == null) {
            return new ArrayList<ResolutionRepository>();
        }
        return server.getVirtualRepositoryKeys(resolverOverrider, null);
    }

    public static List<ResolutionRepository> generateResolutionRepos(ArtifactoryManager artifactoryManager) throws IOException {
        List virtualRepoKeys;
        ArrayList resolutionRepoKeys = artifactoryManager.getRemoteRepositoriesKeys();
        if (resolutionRepoKeys == null) {
            resolutionRepoKeys = new ArrayList();
        }
        if ((virtualRepoKeys = artifactoryManager.getVirtualRepositoriesKeys()) != null) {
            resolutionRepoKeys.addAll(virtualRepoKeys);
        }
        return resolutionRepoKeys.stream().map(repoKey -> new ResolutionRepository((String)repoKey, (String)repoKey)).collect(Collectors.toList());
    }

    public static List<Repository> generateDeploymentRepos(ArtifactoryManager artifactoryManager) throws IOException {
        List federatedRepoKeys;
        List virtualRepoKeys;
        ArrayList deploymentRepoKeys = artifactoryManager.getLocalRepositoriesKeys();
        if (deploymentRepoKeys == null) {
            deploymentRepoKeys = new ArrayList();
        }
        if ((virtualRepoKeys = artifactoryManager.getVirtualRepositoriesKeys()) != null) {
            deploymentRepoKeys.addAll(virtualRepoKeys);
        }
        if ((federatedRepoKeys = artifactoryManager.getFederatedRepositoriesKeys()) != null) {
            deploymentRepoKeys.addAll(federatedRepoKeys);
        }
        return deploymentRepoKeys.stream().map(Repository::new).collect(Collectors.toList());
    }

    public static List<ResolutionRepository> getResolutionRepositoryKeys(String url, CredentialsConfig credentialsConfig, ArtifactoryServer artifactoryServer, Item item) throws IOException {
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(credentialsConfig, artifactoryServer);
        Credentials resolverCredentials = preferredResolver.provideCredentials(item);
        try (ArtifactoryManager artifactoryManager = RepositoriesUtils.createArtifactoryManager(url, resolverCredentials, artifactoryServer);){
            List<ResolutionRepository> list = RepositoriesUtils.generateResolutionRepos(artifactoryManager);
            return list;
        }
    }

    public static List<Repository> getDeploymentRepositories(String url, CredentialsConfig credentialsConfig, ArtifactoryServer artifactoryServer, Item item) throws IOException {
        CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(credentialsConfig, artifactoryServer);
        Credentials deployerCredentials = preferredDeployer.provideCredentials(item);
        try (ArtifactoryManager artifactoryManager = RepositoriesUtils.createArtifactoryManager(url, deployerCredentials, artifactoryServer);){
            List<Repository> list = RepositoriesUtils.generateDeploymentRepos(artifactoryManager);
            return list;
        }
    }

    private static ArtifactoryManager createArtifactoryManager(String url, Credentials credentials, ArtifactoryServer artifactoryServer) {
        ArtifactoryManager artifactoryManager = StringUtils.isNotBlank((CharSequence)credentials.getUsername()) || StringUtils.isNotBlank((CharSequence)credentials.getAccessToken()) ? new ArtifactoryManager(url, credentials.getUsername(), credentials.getPassword(), credentials.getAccessToken(), (Log)new NullLog()) : new ArtifactoryManager(url, (Log)new NullLog());
        artifactoryManager.setConnectionTimeout(artifactoryServer.getTimeout());
        RepositoriesUtils.setRetryParams(artifactoryServer, artifactoryManager);
        if (Jenkins.get().proxy != null && !artifactoryServer.isBypassProxy()) {
            artifactoryManager.setProxyConfiguration(ProxyUtils.createProxyConfiguration());
        }
        return artifactoryManager;
    }

    public static ArtifactoryServer getArtifactoryServer(String key) {
        JFrogPlatformInstance JFrogPlatformInstance2 = RepositoriesUtils.getJFrogPlatformInstances(key);
        if (JFrogPlatformInstance2 != null) {
            return JFrogPlatformInstance2.getArtifactory();
        }
        return null;
    }

    public static JFrogPlatformInstance getJFrogPlatformInstances(String key) {
        List<JFrogPlatformInstance> jfrogInstances = RepositoriesUtils.getJFrogPlatformInstances();
        if (jfrogInstances != null && jfrogInstances.size() > 0) {
            for (JFrogPlatformInstance JFrogPlatformInstance2 : jfrogInstances) {
                if (!JFrogPlatformInstance2.getArtifactory().getArtifactoryUrl().equals(key) && !JFrogPlatformInstance2.getArtifactory().getServerId().equals(key)) continue;
                return JFrogPlatformInstance2;
            }
        }
        return null;
    }

    public static List<JFrogPlatformInstance> getJFrogPlatformInstances() {
        ArtifactoryBuilder.DescriptorImpl descriptor = (ArtifactoryBuilder.DescriptorImpl)Hudson.get().getDescriptor(ArtifactoryBuilder.class);
        return descriptor.getJfrogInstances();
    }

    public static List<Repository> createRepositoriesList(List<String> repositoriesValueList) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (String repositoryKey : repositoriesValueList) {
            Repository repository = new Repository(repositoryKey);
            repositories.add(repository);
        }
        return repositories;
    }

    public static List<ResolutionRepository> collectResolutionRepositories(List<ResolutionRepository> repositories, String repoKey) {
        if (repositories == null) {
            repositories = new ArrayList<ResolutionRepository>();
        }
        if (StringUtils.isNotBlank((CharSequence)repoKey)) {
            for (ResolutionRepository repository : repositories) {
                if (!repoKey.equals(repository.getDisplayName())) continue;
                return repositories;
            }
            repositories.add(new ResolutionRepository(repoKey, repoKey));
        }
        return repositories;
    }

    public static List<Repository> collectRepositories(String repoKey) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (StringUtils.isNotBlank((CharSequence)repoKey)) {
            Repository r = new Repository(repoKey);
            repositories.add(r);
        }
        return repositories;
    }

    public static void validateServerConfig(AbstractBuild build, BuildListener listener, ArtifactoryServer artifactoryServer, String artifactoryUrl) throws IOException {
        if (artifactoryServer == null) {
            String error = "No Artifactory server configured for " + artifactoryUrl + ". Please check your configuration.";
            listener.getLogger().println(error);
            throw new IOException(error);
        }
    }

    private static void setRetryParams(ArtifactoryServer artifactoryServer, ArtifactoryManager artifactoryManager) {
        RepositoriesUtils.setRetryParams(artifactoryServer.getConnectionRetry(), artifactoryManager);
    }

    public static void setRetryParams(int connectionRetry, ArtifactoryManager artifactoryManager) {
        artifactoryManager.setConnectionRetries(connectionRetry);
    }
}

