/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.converters;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.util.XStream2;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jfrog.hudson.ArtifactoryBuilder;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.JFrogPlatformInstance;

public class ArtifactoryBuilderConverter
extends XStream2.PassthruConverter<ArtifactoryBuilder.DescriptorImpl> {
    Logger logger = Logger.getLogger(ArtifactoryBuilderConverter.class.getName());
    List<String> converterErrors = new ArrayList<String>();

    public ArtifactoryBuilderConverter(XStream2 xstream) {
        super(xstream);
    }

    protected void callback(ArtifactoryBuilder.DescriptorImpl artifactoryBuilder, UnmarshallingContext unmarshallingContext) {
        this.jfrogPlatformMigration(artifactoryBuilder);
        if (!this.converterErrors.isEmpty()) {
            this.logger.info(this.converterErrors.toString());
        }
    }

    private void jfrogPlatformMigration(ArtifactoryBuilder.DescriptorImpl artifactoryBuilder) {
        Class<?> overriderClass = ((Object)((Object)artifactoryBuilder)).getClass();
        Field artifactoryServersField = null;
        try {
            artifactoryServersField = overriderClass.getDeclaredField("artifactoryServers");
            Field jfrogInstancesField = overriderClass.getDeclaredField("jfrogInstances");
            artifactoryServersField.setAccessible(true);
            jfrogInstancesField.setAccessible(true);
            Object artifactoryServersObj = artifactoryServersField.get((Object)artifactoryBuilder);
            Object jfrogServersObj = jfrogInstancesField.get((Object)artifactoryBuilder);
            if (artifactoryServersObj != null && jfrogServersObj == null) {
                List artifactoryServers = (List)artifactoryServersObj;
                ArrayList<JFrogPlatformInstance> jfrogInstances = new ArrayList<JFrogPlatformInstance>();
                for (ArtifactoryServer artifactoryServer : artifactoryServers) {
                    jfrogInstances.add(new JFrogPlatformInstance(artifactoryServer));
                }
                jfrogInstancesField.set((Object)artifactoryBuilder, jfrogInstances);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.converterErrors.add(this.getConversionErrorMessage(artifactoryBuilder, e));
        }
    }

    private String getConversionErrorMessage(ArtifactoryBuilder.DescriptorImpl artifactoryBuilder, Exception e) {
        return String.format("Could not convert the class '%s' to use the new overridingformat. Cause: %s", ((Object)((Object)artifactoryBuilder)).getClass().getName(), e.getCause());
    }
}

