/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.converters;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.util.Credentials;

public class CredentialsConfigConverter
extends XStream2.PassthruConverter<CredentialsConfig> {
    Logger logger = Logger.getLogger(CredentialsConfigConverter.class.getName());
    List<String> converterErrors = new ArrayList<String>();

    public CredentialsConfigConverter(XStream2 xstream) {
        super(xstream);
    }

    protected void callback(CredentialsConfig credentialsConfig, UnmarshallingContext context) {
        if (credentialsConfig == null) {
            return;
        }
        this.credentialsConversion(credentialsConfig);
        if (!this.converterErrors.isEmpty()) {
            this.logger.info(this.converterErrors.toString());
        }
    }

    private void credentialsConversion(CredentialsConfig credentialsConfig) {
        try {
            Class<?> credentialsConfigClass = credentialsConfig.getClass();
            Field credentialsField = credentialsConfigClass.getDeclaredField("credentials");
            credentialsField.setAccessible(true);
            Object credentialsObj = credentialsField.get(credentialsConfig);
            if (credentialsObj != null) {
                Credentials credentials = (Credentials)credentialsObj;
                Field usernameField = credentialsConfigClass.getDeclaredField("username");
                usernameField.setAccessible(true);
                usernameField.set(credentialsConfig, Secret.fromString((String)credentials.getUsername()));
                Field passwordField = credentialsConfigClass.getDeclaredField("password");
                passwordField.setAccessible(true);
                passwordField.set(credentialsConfig, Secret.fromString((String)Scrambler.descramble((String)credentials.getPassword())));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.converterErrors.add(this.getConversionErrorMessage(credentialsConfig, e));
        }
    }

    private String getConversionErrorMessage(CredentialsConfig credentialsConfig, Exception e) {
        return String.format("Could not convert the class '%s' to use the new format. Cause: %s", credentialsConfig.getClass().getName(), e.getCause());
    }
}

