/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.plugins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jfrog.hudson.ArtifactoryBuilder;
import org.jfrog.hudson.util.Credentials;

public class PluginsUtils {
    public static final String MULTIJOB_PLUGIN_ID = "jenkins-multijob-plugin";
    public static final String PROMOTION_BUILD_PLUGIN_CLASS = "PromotionProcess";
    public static final String JIRA_REST_SERVERINFO_ENDPOINT = "rest/api/2/serverInfo";
    private static ObjectMapper mapper;

    public static ListBoxModel fillPluginProjectCredentials(Item project) {
        if (project == null || !project.hasPermission(Item.CONFIGURE)) {
            return new StandardListBoxModel();
        }
        return PluginsUtils.fillPluginCredentials(project);
    }

    public static ListBoxModel fillPluginCredentials(Item project) {
        List domainRequirements = Collections.emptyList();
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, project, StandardCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class)})).includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class)}));
    }

    public static Credentials usernamePasswordCredentialsLookup(String credentialsId, Item item) {
        UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull(PluginsUtils.lookupCredentials(UsernamePasswordCredentials.class, item), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (usernamePasswordCredentials != null) {
            return new Credentials(usernamePasswordCredentials.getUsername(), usernamePasswordCredentials.getPassword().getPlainText());
        }
        return Credentials.EMPTY_CREDENTIALS;
    }

    public static StringCredentials accessTokenCredentialsLookup(String credentialsId, Item item) {
        return (StringCredentials)CredentialsMatchers.firstOrNull(PluginsUtils.lookupCredentials(StringCredentials.class, item), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    private static <C extends com.cloudbees.plugins.credentials.Credentials> Iterable<C> lookupCredentials(Class<C> type, Item item) {
        HashSet credentials = new HashSet();
        Authentication authentication = item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM;
        credentials.addAll(CredentialsProvider.lookupCredentials(type, (Item)item, (Authentication)authentication, Collections.emptyList()));
        credentials.addAll(CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.get(), (Authentication)authentication, Collections.emptyList()));
        return credentials;
    }

    public static boolean isUseCredentialsPlugin() {
        return PluginsUtils.getDescriptor().getUseCredentialsPlugin();
    }

    private static ArtifactoryBuilder.DescriptorImpl getDescriptor() {
        ArtifactoryBuilder.DescriptorImpl descriptor = (ArtifactoryBuilder.DescriptorImpl)Hudson.get().getDescriptor(ArtifactoryBuilder.class);
        if (descriptor != null) {
            return descriptor;
        }
        throw new IllegalStateException("ArtifactoryBuilder descriptor is null");
    }

    public static boolean isCredentialsPluginEnabled() {
        return PluginsUtils.getDescriptor().getUseCredentialsPlugin();
    }

    /*
     * Exception decompiling
     */
    public static String getJiraVersion(URL jiraBaseUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void lazyInitMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
    }
}

