/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.publisher;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.util.IncludesExcludes;

public class PublisherContext {
    private ArtifactoryServer artifactoryServer;
    private ServerDetails serverDetails;
    private DeployerOverrider deployerOverrider;
    private boolean discardOldBuilds;
    private boolean discardBuildArtifacts;
    private boolean asyncBuildRetention;
    private boolean deployArtifacts;
    private int threads;
    private IncludesExcludes includesExcludes;
    private boolean skipBuildInfoDeploy;
    private boolean includeEnvVars;
    private IncludesExcludes envVarsPatterns;
    private boolean evenIfUnstable;
    private Boolean deployMaven;
    private Boolean deployIvy;
    private String artifactsPattern = "";
    private String ivyPattern = "";
    private String deploymentProperties;
    private boolean maven2Compatible;
    private boolean enableIssueTrackerIntegration;
    private boolean aggregateBuildIssues;
    private String aggregationBuildStatus;
    private boolean filterExcludedArtifactsFromBuild = true;
    private boolean recordAllDependencies;
    private String artifactoryPluginVersion;
    private String customBuildName;
    private boolean overrideBuildName;
    private int connectionRetry;
    private List<String> gradlePublications;
    private String project;

    private PublisherContext() {
    }

    public ArtifactoryServer getArtifactoryServer() {
        return this.artifactoryServer;
    }

    public String getArtifactsPattern() {
        return this.getCleanString(this.artifactsPattern);
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public String getIvyPattern() {
        return this.getCleanString(this.ivyPattern);
    }

    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    public ServerDetails getServerDetails() {
        return this.serverDetails;
    }

    public IncludesExcludes getIncludesExcludes() {
        return this.includesExcludes;
    }

    public boolean isSkipBuildInfoDeploy() {
        return this.skipBuildInfoDeploy;
    }

    public boolean isRecordAllDependencies() {
        return this.recordAllDependencies;
    }

    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    public DeployerOverrider getDeployerOverrider() {
        return this.deployerOverrider;
    }

    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    public String getCustomBuildName() {
        return this.customBuildName;
    }

    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getConnectionRetry() {
        return this.connectionRetry;
    }

    public final String getArtifactoryName() {
        return this.serverDetails != null ? this.serverDetails.artifactoryName : null;
    }

    public Boolean isDeployMaven() {
        return this.deployMaven;
    }

    public Boolean isDeployIvy() {
        return this.deployIvy;
    }

    public boolean isEvenIfUnstable() {
        return this.evenIfUnstable;
    }

    private String getCleanString(String stringToClean) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)stringToClean, (String)"\""), (String)"\"");
    }

    public boolean isMaven2Compatible() {
        return this.maven2Compatible;
    }

    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    public String getArtifactoryPluginVersion() {
        return this.artifactoryPluginVersion;
    }

    public void setArtifactoryPluginVersion(String artifactoryPluginVersion) {
        this.artifactoryPluginVersion = artifactoryPluginVersion;
    }

    public List<String> getGradlePublications() {
        return this.gradlePublications;
    }

    public String getProject() {
        return this.project;
    }

    public static class Builder {
        PublisherContext publisher = new PublisherContext();

        public PublisherContext build() {
            if (this.publisher.serverDetails == null) {
                throw new IllegalArgumentException("serverDetails cannot be null");
            }
            return this.publisher;
        }

        public Builder artifactoryServer(ArtifactoryServer artifactoryServer) {
            this.publisher.artifactoryServer = artifactoryServer;
            return this;
        }

        public Builder serverDetails(ServerDetails serverDetails) {
            this.publisher.serverDetails = serverDetails;
            return this;
        }

        public Builder deployerOverrider(DeployerOverrider deployerOverrider) {
            this.publisher.deployerOverrider = deployerOverrider;
            return this;
        }

        public Builder overrideBuildName(boolean overrideBuildName) {
            this.publisher.overrideBuildName = overrideBuildName;
            return this;
        }

        public Builder discardOldBuilds(boolean discardOldBuilds) {
            this.publisher.discardOldBuilds = discardOldBuilds;
            return this;
        }

        public Builder deployArtifacts(boolean deployArtifacts) {
            this.publisher.deployArtifacts = deployArtifacts;
            return this;
        }

        public Builder threads(int threads) {
            this.publisher.threads = threads;
            return this;
        }

        public Builder includesExcludes(IncludesExcludes includesExcludes) {
            this.publisher.includesExcludes = includesExcludes;
            return this;
        }

        public Builder skipBuildInfoDeploy(boolean skipBuildInfoDeploy) {
            this.publisher.skipBuildInfoDeploy = skipBuildInfoDeploy;
            return this;
        }

        public Builder recordAllDependencies(boolean recordAllDependencies) {
            this.publisher.recordAllDependencies = recordAllDependencies;
            return this;
        }

        public Builder includeEnvVars(boolean includeEnvVars) {
            this.publisher.includeEnvVars = includeEnvVars;
            return this;
        }

        public Builder envVarsPatterns(IncludesExcludes envVarsPatterns) {
            this.publisher.envVarsPatterns = envVarsPatterns;
            return this;
        }

        public Builder discardBuildArtifacts(boolean discardBuildArtifacts) {
            this.publisher.discardBuildArtifacts = discardBuildArtifacts;
            return this;
        }

        public Builder asyncBuildRetention(boolean asyncBuildRetention) {
            this.publisher.asyncBuildRetention = asyncBuildRetention;
            return this;
        }

        public Builder deploymentProperties(String deploymentProperties) {
            this.publisher.deploymentProperties = deploymentProperties;
            return this;
        }

        public Builder artifactsPattern(String artifactsPattern) {
            this.publisher.artifactsPattern = artifactsPattern;
            return this;
        }

        public Builder ivyPattern(String ivyPattern) {
            this.publisher.ivyPattern = ivyPattern;
            return this;
        }

        public Builder deployMaven(Boolean deployMaven) {
            this.publisher.deployMaven = deployMaven;
            return this;
        }

        public Builder deployIvy(Boolean deployIvy) {
            this.publisher.deployIvy = deployIvy;
            return this;
        }

        public Builder evenIfUnstable(boolean evenIfUnstable) {
            this.publisher.evenIfUnstable = evenIfUnstable;
            return this;
        }

        public Builder maven2Compatible(boolean maven2Compatible) {
            this.publisher.maven2Compatible = maven2Compatible;
            return this;
        }

        public Builder enableIssueTrackerIntegration(boolean enableIssueTrackerIntegration) {
            this.publisher.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
            return this;
        }

        public Builder aggregateBuildIssues(boolean aggregateBuildIssues) {
            this.publisher.aggregateBuildIssues = aggregateBuildIssues;
            return this;
        }

        public Builder aggregationBuildStatus(String aggregationBuildStatus) {
            this.publisher.aggregationBuildStatus = aggregationBuildStatus;
            return this;
        }

        public Builder filterExcludedArtifactsFromBuild(boolean filterExcludedArtifactsFromBuild) {
            this.publisher.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
            return this;
        }

        public Builder artifactoryPluginVersion(String artifactoryPluginVersion) {
            this.publisher.artifactoryPluginVersion = artifactoryPluginVersion;
            return this;
        }

        public Builder customBuildName(String customBuildName) {
            this.publisher.customBuildName = customBuildName;
            return this;
        }

        public Builder connectionRetry(int connectionRetry) {
            this.publisher.connectionRetry = connectionRetry;
            return this;
        }

        public Builder publications(List<String> publications) {
            this.publisher.gradlePublications = publications;
            return this;
        }

        public Builder project(String project) {
            this.publisher.project = project;
            return this;
        }
    }
}

