/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.publisher;

import hudson.model.AbstractProject;
import hudson.tasks.Publisher;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkins_ci.plugins.flexible_publish.ConditionalPublisher;
import org.jenkins_ci.plugins.flexible_publish.FlexiblePublisher;
import org.jfrog.hudson.util.publisher.PublisherFind;

public class PublisherFlexible<T extends Publisher>
implements PublisherFind<T> {
    public static final String FLEXIBLE_PUBLISH_PLUGIN = "flexible-publish";

    private T getWrappedPublisher(Publisher flexiblePublisher, Class<T> type) {
        if (!(flexiblePublisher instanceof FlexiblePublisher)) {
            throw new IllegalArgumentException(String.format("Publisher should be of type: '%s'. Found type: '%s'", FlexiblePublisher.class, flexiblePublisher.getClass()));
        }
        List conditions = ((FlexiblePublisher)flexiblePublisher).getPublishers();
        for (ConditionalPublisher condition : conditions) {
            if (!type.isInstance(condition.getPublisherList().get(0))) continue;
            return (T)((Publisher)type.cast(condition.getPublisherList().get(0)));
        }
        return null;
    }

    @Override
    public T find(AbstractProject<?, ?> project, Class<T> type) {
        if (Jenkins.get().getPlugin(FLEXIBLE_PUBLISH_PLUGIN) != null) {
            for (Publisher publisher : project.getPublishersList()) {
                T pub;
                if (!(publisher instanceof FlexiblePublisher) || (pub = this.getWrappedPublisher(publisher, type)) == null) continue;
                return pub;
            }
        }
        return null;
    }

    public boolean isPublisherWrapped(AbstractProject<?, ?> project, Class<T> type) {
        return this.find(project, type) != null;
    }
}

