/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.audit_trail.AbstractLogFileAuditLogger;
import hudson.plugins.audit_trail.AuditLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.kohsuke.stapler.DataBoundConstructor;

public class LogFileDailyRotationAuditLogger
extends AbstractLogFileAuditLogger {
    private static final Logger LOGGER = Logger.getLogger(LogFileDailyRotationAuditLogger.class.getName());
    static final String DAILY_ROTATING_FILE_REGEX_PATTERN = "-[0-9]{4}-[0-9]{2}-[0-9]{2}.*(?<!lck)$";
    private transient ZonedDateTime initInstant;
    private transient Path basePattern;

    String getLogFilePath() {
        return this.computePattern();
    }

    @Override
    FileHandler getLogFileHandler() throws IOException {
        return new FileHandler(this.getLogFilePath(), 0, 1, true);
    }

    @DataBoundConstructor
    public LogFileDailyRotationAuditLogger(String log, int count, String logSeparator) {
        super(log, count, logSeparator);
        this.basePattern = Paths.get(log, new String[0]);
        this.initializeDailyRotation();
    }

    @Override
    Object readResolve() {
        this.basePattern = Paths.get(this.getLog(), new String[0]);
        super.readResolve();
        this.initializeDailyRotation();
        return this;
    }

    private void initializeDailyRotation() {
        Collection files;
        Path directoryPath = this.basePattern.getParent();
        boolean directoryExists = false;
        if (directoryPath != null) {
            directoryExists = directoryPath.toFile().exists();
        }
        if (directoryExists && (files = FileUtils.listFiles((File)new File(directoryPath.toString()), (IOFileFilter)new RegexFileFilter(".*" + FilenameUtils.getName((String)this.basePattern.toString()) + DAILY_ROTATING_FILE_REGEX_PATTERN), (IOFileFilter)DirectoryFileFilter.DIRECTORY)).size() > 0) {
            List orderedList = files.stream().sorted(LastModifiedFileComparator.LASTMODIFIED_REVERSE).collect(Collectors.toList());
            File lastFile = (File)orderedList.get(0);
            Matcher matcher = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}").matcher(lastFile.getName());
            if (matcher.find()) {
                this.initInstant = Instant.parse(matcher.group(0) + "T00:00:00.00Z").atZone(ZoneId.systemDefault());
            }
        }
        if (this.initInstant == null) {
            this.initInstant = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
        }
        this.configure();
    }

    String computePattern() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault());
        String formattedInstant = formatter.format(this.initInstant);
        String computedFileName = String.format("%s-%s", FilenameUtils.getName((String)this.basePattern.toString()), formattedInstant);
        Path parentFolder = this.basePattern.getParent();
        if (parentFolder != null) {
            return parentFolder.resolve(computedFileName).toString();
        }
        return computedFileName;
    }

    private boolean shouldRotate() {
        return ZonedDateTime.now().isAfter(this.initInstant.plus(Duration.ofDays(1L)));
    }

    private void rotate() {
        if (this.getHandler() != null) {
            this.getHandler().close();
        }
        this.initInstant = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
        this.configure();
        this.removeOldFiles();
    }

    private void removeOldFiles() {
        Collection files;
        Path directoryPath = this.basePattern.getParent();
        if (directoryPath != null && (files = FileUtils.listFiles((File)directoryPath.toFile(), (IOFileFilter)new RegexFileFilter(".*" + FilenameUtils.getName((String)this.basePattern.toString()) + DAILY_ROTATING_FILE_REGEX_PATTERN), (IOFileFilter)DirectoryFileFilter.DIRECTORY)).size() > this.getCount()) {
            List orderedList = files.stream().sorted(LastModifiedFileComparator.LASTMODIFIED_REVERSE).collect(Collectors.toList());
            List toDelete = orderedList.subList(this.getCount(), orderedList.size());
            for (File file : toDelete) {
                if (file.delete()) continue;
                LOGGER.log(Level.SEVERE, "File {0} could not be removed on rotate overation", file.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String event) {
        if (this.shouldRotate()) {
            LogFileDailyRotationAuditLogger logFileDailyRotationAuditLogger = this;
            synchronized (logFileDailyRotationAuditLogger) {
                if (this.shouldRotate()) {
                    this.rotate();
                }
            }
        }
        super.log(event);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AuditLogger> {
        public String getDisplayName() {
            return "Log file daily rotation";
        }
    }
}

