/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.Util;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.branch.BranchProperty;
import jenkins.scm.api.SCMHead;
import jenkins.scm.impl.NullSCMSource;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class Branch {
    private final String sourceId;
    private final SCMHead head;
    private final SCM scm;
    private final List<BranchProperty> properties = new CopyOnWriteArrayList<BranchProperty>();

    public Branch(String sourceId, SCMHead head, SCM scm, List<? extends BranchProperty> properties) {
        this.sourceId = sourceId;
        this.head = head;
        this.scm = scm;
        this.properties.addAll(properties);
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.head.getName();
    }

    public String getEncodedName() {
        return Util.rawEncode((String)this.getName());
    }

    @Exported
    public SCMHead getHead() {
        return this.head;
    }

    @Exported
    public SCM getScm() {
        return this.scm;
    }

    public boolean hasProperty(Class<? extends BranchProperty> clazz) {
        return this.getProperty(clazz) != null;
    }

    public <T extends BranchProperty> T getProperty(Class<T> clazz) {
        for (BranchProperty p : this.properties) {
            if (!clazz.isInstance((Object)p)) continue;
            return (T)((Object)((BranchProperty)((Object)clazz.cast((Object)p))));
        }
        return null;
    }

    public List<BranchProperty> getProperties() {
        return this.properties;
    }

    public boolean isBuildable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Branch)) {
            return false;
        }
        Branch branch = (Branch)o;
        if (this.sourceId != null ? !this.sourceId.equals(branch.sourceId) : branch.sourceId != null) {
            return false;
        }
        return this.head.equals((Object)branch.head);
    }

    public int hashCode() {
        int result = this.sourceId != null ? this.sourceId.hashCode() : 0;
        result = 31 * result + this.head.hashCode();
        return result;
    }

    public static class Dead
    extends Branch {
        public Dead(SCMHead name, List<? extends BranchProperty> properties) {
            super(NullSCMSource.ID, name, (SCM)new NullSCM(), properties);
        }

        @Override
        public boolean isBuildable() {
            return false;
        }
    }
}

