/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jenkins.branch.BranchProperty;
import jenkins.branch.JobDecorator;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.Exported;

public abstract class ParameterDefinitionBranchProperty
extends BranchProperty {
    private List<ParameterDefinition> parameterDefinitions;

    protected ParameterDefinitionBranchProperty() {
    }

    @Exported
    public final List<ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    @DataBoundSetter
    public final void setParameterDefinitions(List<ParameterDefinition> parameterDefinitions) {
        this.parameterDefinitions = parameterDefinitions;
    }

    protected <P extends Job<P, B>, B extends Run<P, B>> boolean isApplicable(Class<P> clazz) {
        return true;
    }

    @Override
    public final <P extends Job<P, B>, B extends Run<P, B>> JobDecorator<P, B> jobDecorator(Class<P> clazz) {
        if (!this.isApplicable(clazz)) {
            return null;
        }
        return new JobDecorator<P, B>(){

            @Override
            @NonNull
            public List<JobProperty<? super P>> jobProperties(@NonNull List<JobProperty<? super P>> jobProperties) {
                ArrayList result = BranchProperty.asArrayList(jobProperties);
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    JobProperty p = (JobProperty)iterator.next();
                    if (!(p instanceof ParametersDefinitionProperty)) continue;
                    iterator.remove();
                }
                if (ParameterDefinitionBranchProperty.this.parameterDefinitions != null && !ParameterDefinitionBranchProperty.this.parameterDefinitions.isEmpty()) {
                    result.add((JobProperty)new ParametersDefinitionProperty(ParameterDefinitionBranchProperty.this.parameterDefinitions));
                }
                return result;
            }
        };
    }
}

