/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import hudson.Extension;
import hudson.Util;
import hudson.model.Hudson;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.metadata.AvatarMetadataAction;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class MetadataActionFolderIcon
extends FolderIcon {
    private AbstractFolder<?> owner;

    @DataBoundConstructor
    public MetadataActionFolderIcon() {
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.owner = folder;
    }

    public String getIconClassName() {
        if (this.owner != null) {
            String result;
            if (this.owner.isDisabled()) {
                return "icon-folder-disabled";
            }
            AvatarMetadataAction action = (AvatarMetadataAction)this.owner.getAction(AvatarMetadataAction.class);
            if (action != null) {
                result = action.getAvatarIconClassName();
                if (result != null) {
                    return result;
                }
                try {
                    if (Util.isOverridden(AvatarMetadataAction.class, action.getClass(), (String)"getAvatarImageOf", (Class[])new Class[]{String.class}) && action.getAvatarImageOf("32x32") != null) {
                        return null;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.owner instanceof IconSpec && (result = ((IconSpec)this.owner).getIconClassName()) != null) {
                return result;
            }
            return this.owner.getDescriptor().getIconClassName();
        }
        return "icon-folder";
    }

    public String getImageOf(String size) {
        String result;
        AvatarMetadataAction action;
        if (this.owner != null && (action = (AvatarMetadataAction)this.owner.getAction(AvatarMetadataAction.class)) != null && (result = action.getAvatarImageOf(size)) != null) {
            return result;
        }
        String image = this.iconClassNameImageOf(size);
        return image != null ? image : Stapler.getCurrentRequest().getContextPath() + Hudson.RESOURCE_PATH + "/plugin/cloudbees-folder/images/" + size + "/folder.png";
    }

    public String getDescription() {
        if (this.owner != null) {
            String result;
            AvatarMetadataAction action = (AvatarMetadataAction)this.owner.getAction(AvatarMetadataAction.class);
            if (action != null && (result = action.getAvatarDescription()) != null) {
                return result;
            }
            return this.owner.getPronoun();
        }
        return "Folder";
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "Metadata Folder Icon";
        }

        public boolean isApplicable(Class<? extends AbstractFolder> folderType) {
            return MultiBranchProject.class.isAssignableFrom(folderType) || OrganizationFolder.class.isAssignableFrom(folderType);
        }
    }
}

