/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.ComputerListener;
import hudson.slaves.WorkspaceList;
import hudson.util.TextFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.slaves.WorkspaceLocator;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension(ordinal=-100.0)
public class WorkspaceLocatorImpl
extends WorkspaceLocator {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceLocatorImpl.class.getName());
    @Deprecated
    static final int PATH_MAX_DEFAULT = 80;
    @Deprecated
    static int PATH_MAX = Integer.getInteger(WorkspaceLocatorImpl.class.getName() + ".PATH_MAX", 80);
    static int MAX_LENGTH = Integer.getInteger(WorkspaceLocatorImpl.class.getName() + ".MAX_LENGTH", 32);
    static Mode MODE = Mode.valueOf(System.getProperty(WorkspaceLocatorImpl.class.getName() + ".MODE", Mode.MULTIBRANCH_ONLY.name()));
    static final String INDEX_FILE_NAME = "workspaces.txt";
    private static final String COMBINATOR = System.getProperty(WorkspaceList.class.getName(), "@");
    private static final Pattern GOOD_RAW_WORKSPACE_DIR = Pattern.compile("[$][{]JENKINS_HOME[}]/(.+)/[$][{]ITEM_FULL_?NAME[}]");

    public FilePath locate(TopLevelItem item, Node node) {
        return WorkspaceLocatorImpl.locate(item, node, true);
    }

    private static FilePath locate(TopLevelItem item, Node node, boolean create) {
        return WorkspaceLocatorImpl.locate(item, item.getFullName(), node, create);
    }

    @CheckForNull
    private static FilePath locate(TopLevelItem item, String fullName, Node node, boolean create) {
        FilePath workspace;
        switch (MODE) {
            case DISABLED: {
                return null;
            }
            case MULTIBRANCH_ONLY: {
                if (item.getParent() instanceof MultiBranchProject) break;
                return null;
            }
            case ENABLED: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if ((workspace = WorkspaceLocatorImpl.getWorkspaceRoot(node)) == null) {
            return null;
        }
        if (fullName.contains("\n") || fullName.equals(INDEX_FILE_NAME)) {
            throw new IllegalArgumentException("Dangerous job name `" + fullName + "`");
        }
        try {
            Node node2 = node;
            synchronized (node2) {
                FilePath dir;
                Map<String, String> index = WorkspaceLocatorImpl.load(workspace);
                String path = index.get(fullName);
                if (path != null) {
                    return workspace.child(path);
                }
                if (PATH_MAX != 0 && item.getParent() instanceof MultiBranchProject && (dir = workspace.child(path = WorkspaceLocatorImpl.minimize(fullName))).isDirectory()) {
                    index.put(fullName, path);
                    WorkspaceLocatorImpl.save(index, workspace);
                    return dir;
                }
                dir = workspace.child(fullName);
                if (dir.isDirectory()) {
                    index.put(fullName, fullName);
                    WorkspaceLocatorImpl.save(index, workspace);
                    return dir;
                }
                if (!create) {
                    return null;
                }
                String mnemonic = WorkspaceLocatorImpl.mnemonicOf(fullName);
                int i = 1;
                while (true) {
                    if (!index.containsKey(path = StringUtils.right((String)(i > 1 ? mnemonic + "_" + i : mnemonic), (int)MAX_LENGTH)) && !(dir = workspace.child(path)).isDirectory()) {
                        index.put(fullName, path);
                        WorkspaceLocatorImpl.save(index, workspace);
                        return dir;
                    }
                    ++i;
                }
            }
        }
        catch (IOException | InterruptedException x) {
            LOGGER.log(Level.WARNING, "could not manage workspaces on " + node, x);
            return null;
        }
    }

    private static Map<String, String> load(FilePath workspace) throws IOException, InterruptedException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        FilePath index = workspace.child(INDEX_FILE_NAME);
        if (index.exists()) {
            try (InputStream is = index.read();
                 InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(r);){
                String key;
                while ((key = br.readLine()) != null) {
                    String value = br.readLine();
                    if (value == null) {
                        throw new IOException("malformed " + index);
                    }
                    map.put(key, value);
                }
            }
        }
        return map;
    }

    private static void save(Map<String, String> index, FilePath workspace) throws IOException, InterruptedException {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, String> entry : index.entrySet()) {
            b.append(entry.getKey()).append('\n').append(entry.getValue()).append('\n');
        }
        workspace.child(INDEX_FILE_NAME).act((FilePath.FileCallable)new WriteAtomic(b.toString()));
    }

    @CheckForNull
    private static FilePath getWorkspaceRoot(Node node) {
        if (node instanceof Jenkins) {
            Matcher m = GOOD_RAW_WORKSPACE_DIR.matcher(((Jenkins)node).getRawWorkspaceDir());
            if (m.matches()) {
                return node.getRootPath().child(m.group(1));
            }
            LOGGER.log(Level.WARNING, "JENKINS-2111 path sanitization ineffective when using legacy Workspace Root Directory \u2018{0}\u2019; switch to $'{'JENKINS_HOME'}'/workspace/$'{'ITEM_FULLNAME'}' as in JENKINS-8446 / JENKINS-21942", ((Jenkins)node).getRawWorkspaceDir());
            return null;
        }
        if (node instanceof Slave) {
            return ((Slave)node).getWorkspaceRoot();
        }
        return null;
    }

    @Deprecated
    private static String uniqueSuffix(String name) {
        byte[] sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256").digest(name.getBytes(Charsets.UTF_16LE));
        }
        catch (NoSuchAlgorithmException x) {
            throw new AssertionError("https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#MessageDigest", x);
        }
        return new Base32(0).encodeToString(sha256).replaceFirst("=+$", "");
    }

    private static String mnemonicOf(String name) {
        return name.replaceAll("(%[0-9A-F]{2}|[^a-zA-Z0-9-_.])+", "_");
    }

    @Deprecated
    static String minimize(String name) {
        String mnemonic = WorkspaceLocatorImpl.mnemonicOf(name);
        int maxSuffix = 53;
        int maxMnemonic = Math.max(PATH_MAX - maxSuffix, 1);
        if (maxSuffix + maxMnemonic > PATH_MAX) {
            LOGGER.log(Level.WARNING, "WorkspaceLocatorImpl.PATH_MAX is small enough that workspace path collisions are more likely to occur");
            int minSuffix = 11;
            maxMnemonic = Math.max((PATH_MAX - 11) / 2, 1);
            maxSuffix = Math.max(PATH_MAX - maxMnemonic, 11);
        }
        String result = StringUtils.right((String)mnemonic, (int)maxMnemonic) + "-" + WorkspaceLocatorImpl.uniqueSuffix(name).substring(0, --maxSuffix);
        return result;
    }

    static /* synthetic */ FilePath access$100(TopLevelItem x0, Node x1, boolean x2) {
        return WorkspaceLocatorImpl.locate(x0, x1, x2);
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ FilePath access$800(TopLevelItem x0, String x1, Node x2, boolean x3) {
        return WorkspaceLocatorImpl.locate(x0, x1, x2, x3);
    }

    @Extension
    public static final class Collector
    extends ComputerListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
            Node node = c.getNode();
            if (node == null) {
                return;
            }
            FilePath workspace = WorkspaceLocatorImpl.getWorkspaceRoot(node);
            if (workspace == null) {
                return;
            }
            Node node2 = node;
            synchronized (node2) {
                Map index = WorkspaceLocatorImpl.load(workspace);
                boolean modified = false;
                try (ACLContext as = ACL.as((Authentication)ACL.SYSTEM);){
                    Iterator it = index.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String fullName = (String)entry.getKey();
                        if (Jenkins.get().getItemByFullName(fullName, TopLevelItem.class) != null) continue;
                        String path = (String)entry.getValue();
                        it.remove();
                        modified = true;
                        for (FilePath child : workspace.listDirectories()) {
                            String childName = child.getName();
                            if (!childName.equals(path) && !childName.startsWith(path + COMBINATOR)) continue;
                            listener.getLogger().println("deleting obsolete workspace " + child);
                            child.deleteRecursive();
                        }
                    }
                }
                if (modified) {
                    WorkspaceLocatorImpl.save(index, workspace);
                }
            }
        }
    }

    @Extension
    public static class Deleter
    extends ItemListener {
        private static int runningTasks;

        public void onDeleted(Item item) {
            if (!(item instanceof TopLevelItem)) {
                return;
            }
            TopLevelItem tli = (TopLevelItem)item;
            Jenkins jenkins = Jenkins.getActiveInstance();
            Computer.threadPoolForRemoting.submit(new CleanupTask(tli, (Node)jenkins));
            for (Node node : jenkins.getNodes()) {
                Computer.threadPoolForRemoting.submit(new CleanupTask(tli, node));
            }
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            if (!(item instanceof TopLevelItem)) {
                return;
            }
            Jenkins jenkins = Jenkins.get();
            Computer.threadPoolForRemoting.submit(new MoveTask(oldFullName, newFullName, (Node)jenkins));
            for (Node node : jenkins.getNodes()) {
                Computer.threadPoolForRemoting.submit(new MoveTask(oldFullName, newFullName, node));
            }
        }

        @VisibleForTesting
        static synchronized void waitForTasksToFinish() throws InterruptedException {
            while (runningTasks > 0) {
                Deleter.class.wait();
            }
        }

        private static synchronized void taskStarted() {
            ++runningTasks;
        }

        private static synchronized void taskFinished() {
            --runningTasks;
            Deleter.class.notifyAll();
        }

        static /* synthetic */ void access$700() {
            Deleter.taskFinished();
        }

        private static class MoveTask
        implements Runnable {
            @NonNull
            private final String oldFullName;
            @NonNull
            private final String newFullName;
            @NonNull
            private final Node node;

            MoveTask(String oldFullName, String newFullName, Node node) {
                this.oldFullName = oldFullName;
                this.newFullName = newFullName;
                this.node = node;
                Deleter.taskStarted();
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }

        private static class CleanupTask
        implements Runnable {
            @NonNull
            private final TopLevelItem tli;
            @NonNull
            private final Node node;

            CleanupTask(TopLevelItem tli, Node node) {
                this.tli = tli;
                this.node = node;
                Deleter.taskStarted();
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
    }

    private static final class WriteAtomic
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final String text;

        WriteAtomic(String text) {
            this.text = text;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            new TextFile(f).write(this.text);
            return null;
        }
    }

    static enum Mode {
        DISABLED,
        MULTIBRANCH_ONLY,
        ENABLED;

    }
}

