/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.EnvironmentContributingAction;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class EnvironmentVarSetter
implements EnvironmentContributingAction {
    @CheckForNull
    private transient PrintStream log;
    private final Map<String, String> envVars = new ConcurrentHashMap<String, String>();
    private static final Logger LOGGER = Logger.getLogger(EnvironmentVarSetter.class.getName());
    public static final String buildDisplayNameVar = "BUILD_DISPLAY_NAME";

    public EnvironmentVarSetter(@CheckForNull String key, @CheckForNull String value, @CheckForNull PrintStream logger) {
        this.log = logger;
        this.envVars.put(key, value);
    }

    public static void setVar(AbstractBuild build, String key, String value, PrintStream logger) {
        EnvironmentVarSetter action = (EnvironmentVarSetter)build.getAction(EnvironmentVarSetter.class);
        if (action == null) {
            action = new EnvironmentVarSetter(key, value, logger);
            build.addAction((Action)action);
        } else {
            action.setVar(key, value);
        }
    }

    public void setVar(@CheckForNull String key, @CheckForNull String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("key shouldn't be null or empty.");
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("value shouldn't be null or empty.");
        }
        if (this.envVars.containsKey(key)) {
            if (!this.envVars.get(key).equals(value)) {
                this.log("Variable with name '%s' already exists, current value: '%s', new value: '%s'", key, this.envVars.get(key), value);
            }
        } else {
            this.log("Create new variable %s=%s", key, value);
        }
        this.envVars.put(key, value);
    }

    public String getVar(String key) {
        if (this.envVars.containsKey(key)) {
            this.log("Get var: %s=%s", key, this.envVars.get(key));
            return this.envVars.get(key);
        }
        this.log("Var '%s' doesn't exist", key);
        return "";
    }

    private void log(String format, Object ... args) {
        if (this.log == null && !LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        String message = format.formatted(args);
        LOGGER.fine(message);
        if (this.log != null) {
            this.log.println(message);
        }
    }

    public void buildEnvVars(AbstractBuild<?, ?> abstractBuild, EnvVars envVars) {
        envVars.putAll(this.envVars);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

