/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;

public class BitbucketSCMSourceRequest
extends SCMSourceRequest {
    private final boolean fetchBranches;
    private final boolean fetchTags;
    private final boolean fetchOriginPRs;
    private final boolean fetchForkPRs;
    private final boolean skipPublicPRs;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> originPRStrategies;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> forkPRStrategies;
    @CheckForNull
    private final Set<String> requestedPullRequestNumbers;
    @CheckForNull
    private final Set<String> requestedOriginBranchNames;
    @CheckForNull
    private final Set<String> requestedTagNames;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    @CheckForNull
    private Iterable<BitbucketPullRequest> pullRequests;
    @CheckForNull
    private Iterable<BitbucketBranch> branches;
    private BitbucketApi api;
    private final BitbucketSCMSource source;
    private final Map<Integer, BitbucketPullRequest> pullRequestData;
    @CheckForNull
    private Iterable<BitbucketBranch> tags;

    protected BitbucketSCMSourceRequest(@NonNull BitbucketSCMSource source, @NonNull BitbucketSCMSourceContext context, @CheckForNull TaskListener listener) {
        super((SCMSource)source, (SCMSourceContext)context, listener);
        this.source = source;
        this.fetchBranches = context.wantBranches();
        this.fetchTags = context.wantTags();
        this.fetchOriginPRs = context.wantOriginPRs();
        this.fetchForkPRs = context.wantForkPRs();
        this.skipPublicPRs = context.skipPublicPRs();
        this.originPRStrategies = this.fetchOriginPRs && !context.originPRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.originPRStrategies())) : Collections.emptySet();
        this.forkPRStrategies = this.fetchForkPRs && !context.forkPRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.forkPRStrategies())) : Collections.emptySet();
        Set includes = context.observer().getIncludes();
        if (includes != null) {
            HashSet<String> pullRequestNumbers = new HashSet<String>(includes.size());
            HashSet<String> branchNames = new HashSet<String>(includes.size());
            HashSet<String> tagNames = new HashSet<String>(includes.size());
            for (SCMHead h : includes) {
                if (h instanceof BranchSCMHead) {
                    branchNames.add(h.getName());
                    continue;
                }
                if (h instanceof PullRequestSCMHead) {
                    PullRequestSCMHead prHead = (PullRequestSCMHead)h;
                    pullRequestNumbers.add(prHead.getId());
                    if (SCMHeadOrigin.DEFAULT.equals((Object)h.getOrigin())) {
                        branchNames.add(prHead.getOriginName());
                    }
                    if (prHead.getCheckoutStrategy() != ChangeRequestCheckoutStrategy.MERGE) continue;
                    branchNames.add(prHead.getTarget().getName());
                    continue;
                }
                if (!(h instanceof BitbucketTagSCMHead)) continue;
                tagNames.add(h.getName());
            }
            this.requestedPullRequestNumbers = Collections.unmodifiableSet(pullRequestNumbers);
            this.requestedOriginBranchNames = Collections.unmodifiableSet(branchNames);
            this.requestedTagNames = Collections.unmodifiableSet(tagNames);
        } else {
            this.requestedPullRequestNumbers = null;
            this.requestedOriginBranchNames = null;
            this.requestedTagNames = null;
        }
        this.repoOwner = source.getRepoOwner();
        this.repository = source.getRepository();
        this.pullRequestData = new HashMap<Integer, BitbucketPullRequest>();
    }

    public final boolean isFetchBranches() {
        return this.fetchBranches;
    }

    public final boolean isFetchTags() {
        return this.fetchTags;
    }

    public final boolean isFetchPRs() {
        return this.isFetchOriginPRs() || this.isFetchForkPRs();
    }

    public final boolean isFetchOriginPRs() {
        return this.fetchOriginPRs;
    }

    public final boolean isFetchForkPRs() {
        return this.fetchForkPRs;
    }

    public final boolean isSkipPublicPRs() {
        return this.skipPublicPRs;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getOriginPRStrategies() {
        return this.originPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getForkPRStrategies() {
        return this.forkPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getPRStrategies(boolean fork) {
        if (fork) {
            return this.fetchForkPRs ? this.getForkPRStrategies() : Collections.emptySet();
        }
        return this.fetchOriginPRs ? this.getOriginPRStrategies() : Collections.emptySet();
    }

    public final Map<Boolean, Set<ChangeRequestCheckoutStrategy>> getPRStrategies() {
        HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>> result = new HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>>();
        for (Boolean fork : new Boolean[]{Boolean.TRUE, Boolean.FALSE}) {
            result.put(fork, this.getPRStrategies(fork));
        }
        return result;
    }

    @CheckForNull
    public final Set<String> getRequestedPullRequestNumbers() {
        return this.requestedPullRequestNumbers;
    }

    @CheckForNull
    public final Set<String> getRequestedOriginBranchNames() {
        return this.requestedOriginBranchNames;
    }

    @CheckForNull
    public final Set<String> getRequestedTagNames() {
        return this.requestedTagNames;
    }

    @NonNull
    public final String getRepoOwner() {
        return this.repoOwner;
    }

    @NonNull
    public final String getRepository() {
        return this.repository;
    }

    public final void setPullRequests(@CheckForNull Iterable<BitbucketPullRequest> pullRequests) {
        this.pullRequests = pullRequests;
    }

    @NonNull
    public final Iterable<BitbucketPullRequest> getPullRequests() throws IOException, InterruptedException {
        if (this.pullRequests == null) {
            this.pullRequests = this.getBitbucketApiClient().getPullRequests();
        }
        return Util.fixNull(this.pullRequests);
    }

    public final BitbucketPullRequest getPullRequestById(Integer id) throws IOException {
        if (!this.pullRequestData.containsKey(id)) {
            this.pullRequestData.put(id, this.getBitbucketApiClient().getPullRequestById(id));
        }
        return this.pullRequestData.get(id);
    }

    private final BitbucketApi getBitbucketApiClient() {
        if (this.api == null) {
            this.api = this.source.buildBitbucketClient();
        }
        return this.api;
    }

    public final void setBranches(@CheckForNull Iterable<BitbucketBranch> branches) {
        this.branches = branches;
    }

    @NonNull
    public final Iterable<BitbucketBranch> getBranches() throws IOException, InterruptedException {
        if (this.branches == null) {
            this.branches = this.getBitbucketApiClient().getBranches();
        }
        return Util.fixNull(this.branches);
    }

    public final void setTags(@CheckForNull Iterable<BitbucketBranch> tags) {
        this.tags = tags;
    }

    @NonNull
    public final Iterable<BitbucketBranch> getTags() throws IOException, InterruptedException {
        if (this.tags == null) {
            this.tags = this.getBitbucketApiClient().getTags();
        }
        return Util.fixNull(this.tags);
    }

    public void close() throws IOException {
        if (this.api != null) {
            this.api.close();
        }
        super.close();
    }

    public final <H extends SCMHead, I, R extends SCMRevision> boolean process(@NonNull H head, @CheckForNull SCMSourceRequest.IntermediateLambda<I> intermediateFactory) throws IOException, InterruptedException {
        return super.process(head, intermediateFactory, this.defaultProbeLamda(), this.defaultRevisionLamda(), new SCMSourceRequest.Witness[]{new CriteriaWitness()});
    }

    @NonNull
    <I> SCMSourceRequest.ProbeLambda<SCMHead, I> defaultProbeLamda() {
        return new BitbucketProbeFactory(this.getBitbucketApiClient());
    }

    @NonNull
    <I> SCMSourceRequest.ProbeLambda<SCMHead, I> buildProbeLamda(@NonNull BitbucketApi client) {
        return new BitbucketProbeFactory(client);
    }

    @NonNull
    <I> SCMSourceRequest.LazyRevisionLambda<SCMHead, SCMRevision, I> defaultRevisionLamda() {
        return new BitbucketRevisionFactory(this.getBitbucketApiClient());
    }

    @NonNull
    SCMSourceRequest.Witness defaultWitness() {
        return new CriteriaWitness();
    }

    private class CriteriaWitness
    implements SCMSourceRequest.Witness {
        private CriteriaWitness() {
        }

        public void record(@NonNull SCMHead scmHead, SCMRevision revision, boolean isMatch) {
            if (revision == null) {
                BitbucketSCMSourceRequest.this.listener().getLogger().println("    Skipped");
            } else if (isMatch) {
                BitbucketSCMSourceRequest.this.listener().getLogger().println("    Met criteria");
            } else {
                BitbucketSCMSourceRequest.this.listener().getLogger().println("    Does not meet criteria");
            }
        }
    }

    private class BitbucketProbeFactory<I>
    implements SCMSourceRequest.ProbeLambda<SCMHead, I> {
        private final transient BitbucketApi client;

        public BitbucketProbeFactory(BitbucketApi client) {
            this.client = client;
        }

        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        @NonNull
        public SCMSourceCriteria.Probe create(final @NonNull SCMHead head, final @CheckForNull I revisionInfo) throws IOException, InterruptedException {
            String string;
            if (revisionInfo instanceof BitbucketCommit) {
                BitbucketCommit bbRevision = (BitbucketCommit)revisionInfo;
                string = bbRevision.getHash();
            } else {
                string = (String)revisionInfo;
            }
            final String hash = string;
            return new SCMProbe(){

                public void close() throws IOException {
                }

                public String name() {
                    return head.getName();
                }

                public long lastModified() {
                    try {
                        BitbucketCommit commit = null;
                        if (hash != null) {
                            BitbucketCommit bbRevision;
                            BitbucketCommit bitbucketCommit = commit = revisionInfo instanceof BitbucketCommit ? (bbRevision = (BitbucketCommit)revisionInfo) : BitbucketProbeFactory.this.client.resolveCommit(hash);
                        }
                        if (commit == null) {
                            BitbucketSCMSourceRequest.this.listener().getLogger().format("Can not resolve commit by hash [%s] on repository %s/%s%n", hash, BitbucketProbeFactory.this.client.getOwner(), BitbucketProbeFactory.this.client.getRepositoryName());
                            return 0L;
                        }
                        return Optional.ofNullable(commit.getCommitterDate()).map(Date::getTime).orElse(0L);
                    }
                    catch (IOException e) {
                        BitbucketSCMSourceRequest.this.listener().getLogger().format("Can not resolve commit by hash [%s] on repository %s/%s%n", hash, BitbucketProbeFactory.this.client.getOwner(), BitbucketProbeFactory.this.client.getRepositoryName());
                        return 0L;
                    }
                }

                public SCMProbeStat stat(@NonNull String path) throws IOException {
                    if (hash == null) {
                        BitbucketSCMSourceRequest.this.listener().getLogger().format("Can not resolve path for hash [%s] on repository %s/%s%n", hash, BitbucketProbeFactory.this.client.getOwner(), BitbucketProbeFactory.this.client.getRepositoryName());
                        return SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                    }
                    try {
                        SCMFile.Type pathType = new BitbucketSCMFile(BitbucketProbeFactory.this.client, this.name(), hash).child(path).getType();
                        return SCMProbeStat.fromType((SCMFile.Type)pathType);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted", e);
                    }
                }
            };
        }
    }

    public static class BitbucketRevisionFactory<I>
    implements SCMSourceRequest.LazyRevisionLambda<SCMHead, SCMRevision, I> {
        private final BitbucketApi client;

        public BitbucketRevisionFactory(BitbucketApi client) {
            this.client = client;
        }

        @NonNull
        public SCMRevision create(@NonNull SCMHead head, @Nullable I input) throws IOException, InterruptedException {
            return this.create(head, input, null);
        }

        @NonNull
        public SCMRevision create(@NonNull SCMHead head, @Nullable I sourceInput, @Nullable I targetInput) throws IOException, InterruptedException {
            BitbucketCommit sourceCommit = this.asCommit(sourceInput);
            BitbucketCommit targetCommit = this.asCommit(targetInput);
            if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                SCMHead targetHead = prHead.getTarget();
                return new PullRequestSCMRevision(prHead, (SCMRevision)new BitbucketGitSCMRevision(targetHead, targetCommit), (SCMRevision)new BitbucketGitSCMRevision(prHead, sourceCommit));
            }
            BitbucketGitSCMRevision revision = new BitbucketGitSCMRevision(head, sourceCommit);
            return revision;
        }

        @Nullable
        private BitbucketCommit asCommit(I input) throws IOException, InterruptedException {
            if (input instanceof String) {
                String value = (String)input;
                return this.client.resolveCommit(value);
            }
            if (input instanceof BitbucketCommit) {
                BitbucketCommit commit = (BitbucketCommit)input;
                return commit;
            }
            return null;
        }
    }
}

