/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.client.events.BitbucketCloudPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.client.events.BitbucketCloudPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BitbucketCloudWebhookPayload {
    private static final Logger LOGGER = Logger.getLogger(BitbucketCloudWebhookPayload.class.getName());

    @CheckForNull
    public static BitbucketPushEvent pushEventFromPayload(@NonNull String payload) {
        try {
            return JsonParser.toJava(payload, BitbucketCloudPushEvent.class);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
            return null;
        }
    }

    @CheckForNull
    public static BitbucketPullRequestEvent pullRequestEventFromPayload(@NonNull String payload) {
        try {
            return JsonParser.toJava(payload, BitbucketCloudPullRequestEvent.class);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
            return null;
        }
    }
}

