/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.client;

import java.io.IOException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.SAFE)
public class BitbucketTlsSocketStrategy
implements TlsSocketStrategy {
    public static final String SOCKET_FACTORY_REGISTRY = "http.socket-factory-registry";
    private TlsSocketStrategy defaultStrategy;

    public SSLSocket upgrade(Socket socket, String target, int port, Object attachment, HttpContext context) throws IOException {
        TlsSocketStrategy strategy = this.defaultStrategy;
        Object value = context.getAttribute(SOCKET_FACTORY_REGISTRY);
        if (value instanceof SSLContext) {
            SSLContext sslContext = (SSLContext)value;
            strategy = new DefaultClientTlsStrategy(sslContext);
        } else if (this.defaultStrategy == null) {
            try {
                strategy = new DefaultClientTlsStrategy(SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            this.defaultStrategy = strategy;
        }
        return strategy.upgrade(socket, target, port, attachment, context);
    }
}

