/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketException;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import hudson.util.Secret;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;

public class BitbucketClientCertificateAuthenticator
implements BitbucketAuthenticator {
    private final String credentialsId;
    private final KeyStore keyStore;
    private final Secret password;

    public BitbucketClientCertificateAuthenticator(StandardCertificateCredentials credentials) {
        this.credentialsId = credentials.getId();
        this.keyStore = credentials.getKeyStore();
        this.password = credentials.getPassword();
    }

    @Override
    public void configureContext(HttpClientContext context, HttpHost host) {
        try {
            context.setAttribute("http.socket-factory-registry", (Object)this.buildSSLContext());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new BitbucketException("Failed to set up SSL context from provided client certificate", e);
        }
    }

    private SSLContext buildSSLContext() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        SSLContextBuilder contextBuilder = SSLContexts.custom();
        contextBuilder.loadKeyMaterial(this.keyStore, Secret.toString((Secret)this.password).toCharArray());
        return contextBuilder.build();
    }

    @Override
    public String getId() {
        return this.credentialsId;
    }
}

