/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.util.Secret;

public class BitbucketOAuthCredentialMatcher
implements CredentialsMatcher {
    private static final long serialVersionUID = 6458784517693211197L;
    private static final int CLIENT_KEY_LENGTH = 18;
    private static final int CLIENT_SECRET_LENGTH = 32;

    public boolean matches(Credentials item) {
        if (!(item instanceof StandardUsernamePasswordCredentials)) {
            return false;
        }
        StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)item;
        String username = credentials.getUsername();
        String password = Secret.toString((Secret)credentials.getPassword());
        boolean isEMail = username.contains(".") && username.contains("@");
        boolean validSecretLength = password.length() == 32;
        boolean validKeyLength = username.length() == 18;
        return !isEMail && validKeyLength && validSecretLength;
    }
}

