/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.utils.Base64;
import org.apache.hc.core5.http.HttpRequest;

public class BitbucketUserAPITokenAuthenticator
implements BitbucketAuthenticator {
    private final String encodedAuth;
    private final String credentialsId;
    private final Secret password;

    public BitbucketUserAPITokenAuthenticator(StandardUsernamePasswordCredentials credentials) {
        this.credentialsId = credentials.getId();
        this.password = credentials.getPassword();
        String auth = credentials.getUsername() + ":" + Secret.toString((Secret)this.password);
        this.encodedAuth = Base64.encodeBase64String((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
    }

    @Override
    public void configureRequest(HttpRequest request) {
        String authHeader = "Basic " + this.encodedAuth;
        request.setHeader("Authorization", (Object)authHeader);
    }

    @Override
    public StandardUsernameCredentials getCredentialsForSCM() {
        try {
            return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, this.getId(), "User API token for " + this.getId(), "x-bitbucket-api-token-auth", Secret.toString((Secret)this.password));
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getId() {
        return this.credentialsId;
    }
}

