/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.HasPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin.AbstractSCMHeadEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;

@Deprecated(since="937.0.0")
final class PluginPREvent
extends AbstractSCMHeadEvent<BitbucketPullRequestEvent>
implements HasPullRequests {
    private final HookEventType hookEvent;

    PluginPREvent(SCMEvent.Type type, BitbucketPullRequestEvent payload, String origin, HookEventType hookEvent) {
        super(type, payload, origin);
        this.hookEvent = hookEvent;
    }

    @Override
    protected BitbucketRepository getRepository() {
        return ((BitbucketPullRequestEvent)this.getPayload()).getRepository();
    }

    @NonNull
    public String getSourceName() {
        return this.getRepository().getRepositoryName();
    }

    @NonNull
    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="false positive, the scope of branchName variable is inside the for cycle, no string contatenation happens into a loop")
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        String pullRepository;
        if (!(source instanceof BitbucketSCMSource)) {
            return Collections.emptyMap();
        }
        BitbucketSCMSource src = (BitbucketSCMSource)source;
        if (!this.isServerURLMatch(src.getServerUrl())) {
            return Collections.emptyMap();
        }
        BitbucketRepository repository = this.getRepository();
        if (!src.getRepoOwner().equalsIgnoreCase(repository.getOwnerName())) {
            return Collections.emptyMap();
        }
        if (!src.getRepository().equalsIgnoreCase(repository.getRepositoryName())) {
            return Collections.emptyMap();
        }
        BitbucketSCMSourceContext ctx = (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(src.getTraits());
        if (!ctx.wantPRs()) {
            return Collections.emptyMap();
        }
        BitbucketPullRequest pull = ((BitbucketPullRequestEvent)this.getPayload()).getPullRequest();
        String pullRepoOwner = pull.getSource().getRepository().getOwnerName();
        SCMHeadOrigin headOrigin = src.originOf(pullRepoOwner, pullRepository = pull.getSource().getRepository().getRepositoryName());
        Set<ChangeRequestCheckoutStrategy> strategies = headOrigin == SCMHeadOrigin.DEFAULT ? ctx.originPRStrategies() : ctx.forkPRStrategies();
        HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>(strategies.size());
        for (ChangeRequestCheckoutStrategy strategy : strategies) {
            String branchName = "PR-" + pull.getId();
            if (strategies.size() > 1) {
                branchName = branchName + "-" + strategy.name().toLowerCase(Locale.ENGLISH);
            }
            String originalBranchName = pull.getSource().getBranch().getName();
            PullRequestSCMHead head = new PullRequestSCMHead(branchName, pullRepoOwner, pullRepository, originalBranchName, pull, headOrigin, strategy);
            if (this.hookEvent == HookEventType.PULL_REQUEST_DECLINED || this.hookEvent == HookEventType.PULL_REQUEST_MERGED) {
                result.put(head, null);
                continue;
            }
            String targetHash = pull.getDestination().getCommit().getHash();
            String pullHash = pull.getSource().getCommit().getHash();
            PullRequestSCMRevision revision = new PullRequestSCMRevision(head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), targetHash), (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, pullHash));
            result.put(head, (SCMRevision)revision);
        }
        return result;
    }

    @Override
    public Iterable<BitbucketPullRequest> getPullRequests(BitbucketSCMSource src) throws InterruptedException {
        if (this.hookEvent == HookEventType.PULL_REQUEST_DECLINED || this.hookEvent == HookEventType.PULL_REQUEST_MERGED) {
            return Collections.emptyList();
        }
        return Collections.singleton(((BitbucketPullRequestEvent)this.getPayload()).getPullRequest());
    }
}

